/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.log;

import java.net.URI;
import java.util.ArrayList;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.log.CookieMap;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;

public class PageInformation {
    public static final PageInformation EMPTY = new PageInformation();
    public final String message;
    public final String origin;
    public final CookieMap cookieMap = new CookieMap();

    private String getMessage(Exception e) {
        String msg = e.getMessage();
        if (msg != null) {
            return msg.replaceFirst("(?s)\r?\nBuild info:.*", "");
        }
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add(e.toString());
        String pkgName = PageInformation.class.getPackage().getName() + ".";
        for (StackTraceElement ste : e.getStackTrace()) {
            if (ste.getClassName().startsWith(pkgName)) break;
            msgs.add(ste.toString().trim());
        }
        return StringUtils.join(msgs, (String)" / at ");
    }

    public PageInformation(Context context) {
        String origin;
        String message;
        WebDriver driver = context.getWrappedDriver();
        try {
            String handle = driver.getWindowHandle();
            if (StringUtils.isEmpty((CharSequence)handle)) {
                throw new NotFoundException();
            }
            driver.switchTo().window(handle);
            String url = driver.getCurrentUrl();
            String title = driver.getTitle();
            message = this.formatUrlAndTitle(url, title);
            origin = this.getOrigin(url);
            for (Cookie cookie : driver.manage().getCookies()) {
                this.cookieMap.add(cookie);
            }
        }
        catch (NotFoundException e) {
            message = "No focused window/frame.";
            origin = "";
        }
        catch (UnhandledAlertException e) {
            message = String.format("No page information: [%s]", this.getMessage((Exception)((Object)e)));
            origin = "";
        }
        catch (Exception e) {
            message = String.format("Failed to get page information: [%s]", this.getMessage(e));
            origin = "";
        }
        this.message = message;
        this.origin = origin;
    }

    private PageInformation() {
        this.message = "";
        this.origin = "";
    }

    private String formatUrlAndTitle(String url, String title) {
        return "URL: [" + url + "] / Title: [" + title + "]";
    }

    private String getOrigin(String url) {
        URI uri = URI.create(url);
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        return port < 0 ? scheme + "//" + host : scheme + "//" + host + ":" + port;
    }

    public String getFirstMessage(PageInformation prevInfo, String indent, String ... prefixes) {
        StringBuilder m = new StringBuilder(indent);
        for (String prefix : prefixes) {
            m.append(prefix).append(' ');
        }
        if (this.origin == null || !this.origin.equals(prevInfo.origin) || !this.message.equals(prevInfo.message)) {
            m.append(this.message);
        } else {
            m.deleteCharAt(m.length() - 1);
        }
        return m.toString();
    }

    public boolean isSameOrigin(PageInformation other) {
        return this.origin != null && this.origin.equals(other.origin);
    }
}

