/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.CommandListIterator;
import jp.vmi.selenium.selenese.command.CommandSequence;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.ILabel;
import jp.vmi.selenium.selenese.command.Screenshot;
import jp.vmi.selenium.selenese.inject.DoCommand;
import jp.vmi.selenium.selenese.result.CommandResult;
import jp.vmi.selenium.selenese.result.CommandResultList;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;

public class CommandList
extends ArrayList<ICommand> {
    private static final long serialVersionUID = 1L;
    private final Map<Object, Integer> indexCache = new HashMap<Object, Integer>();
    private static final Pattern JS_BLOCK_RE = Pattern.compile("javascript\\{(.*)\\}", 32);

    @Override
    public boolean add(ICommand command) {
        if (command instanceof ILabel) {
            this.indexCache.put(((ILabel)((Object)command)).getLabel(), this.size());
        }
        return super.add(command);
    }

    @Override
    public int indexOf(Object key) {
        Integer index = this.indexCache.get(key);
        if (index == null) {
            index = super.indexOf(key);
            this.indexCache.put(key, index);
        }
        return index;
    }

    protected ListIterator<ICommand> originalListIterator(int index) {
        return super.listIterator(index);
    }

    @Deprecated
    public CommandListIterator listIterator(int index) {
        throw new UnsupportedOperationException(new Object(){}.getClass().getEnclosingMethod().toString());
    }

    @Deprecated
    public CommandListIterator listIterator() {
        throw new UnsupportedOperationException(new Object(){}.getClass().getEnclosingMethod().toString());
    }

    public CommandListIterator iterator() {
        return this.iterator(null);
    }

    public CommandListIterator iterator(CommandListIterator parentIterator) {
        return new CommandListIterator(this, parentIterator);
    }

    @DoCommand
    protected Result doCommand(Context context, ICommand command, String ... curArgs) {
        try {
            return command.execute(context, curArgs);
        }
        catch (Exception e) {
            return new Error(e);
        }
    }

    protected void evalCurArgs(Context context, String[] curArgs) {
        for (int i = 0; i < curArgs.length; ++i) {
            Matcher matcher = JS_BLOCK_RE.matcher(curArgs[i]);
            if (!matcher.matches()) continue;
            Object value = context.getEval().eval(context.getWrappedDriver(), matcher.group(1));
            if (value == null) {
                value = "";
            }
            curArgs[i] = value.toString();
        }
    }

    @Deprecated
    public Result execute(Context context) {
        return this.execute(context, new CommandResultList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Context context, CommandResultList cresultList) {
        CommandListIterator parentIterator = context.getCommandListIterator();
        CommandListIterator commandListIterator = this.iterator(parentIterator);
        context.pushCommandListIterator(commandListIterator);
        CommandSequence sequence = commandListIterator.getCommandSequence();
        boolean isContinued = true;
        try {
            while (isContinued && commandListIterator.hasNext()) {
                ICommand command = commandListIterator.next();
                sequence.increment(command);
                List<Screenshot> ss = command.getScreenshots();
                int prevSSIndex = ss == null ? 0 : ss.size();
                String[] curArgs = context.getVarsMap().replaceVarsForArray(command.getArguments());
                this.evalCurArgs(context, curArgs);
                Result result = this.doCommand(context, command, curArgs);
                if (result.isAborted()) {
                    isContinued = false;
                } else {
                    context.waitSpeed();
                }
                ss = command.getScreenshots();
                ArrayList<Screenshot> newSS = ss == null || prevSSIndex == ss.size() ? null : new ArrayList<Screenshot>(ss.subList(prevSSIndex, ss.size()));
                CommandResult cresult = new CommandResult(sequence.toString(), command, newSS, result, cresultList.getEndTime(), System.currentTimeMillis());
                cresultList.add(cresult);
            }
        }
        finally {
            context.popCommandListIterator();
        }
        return cresultList.getResult();
    }
}

