/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import com.thoughtworks.selenium.SeleniumException;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.result.Failure;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.subcommand.ISubCommand;
import jp.vmi.selenium.selenese.utils.SeleniumUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BuiltInCommand
extends AbstractCommand {
    private static final String WAIT_FOR_PAGE_TO_LOAD = "waitForPageToLoad";
    private static final String[] NO_UPDATE_SCREEN = new String[]{"createCookie", "deleteCookie", "deleteAllVisibleCookies"};
    private final ISubCommand<?> subCommand;
    private final boolean andWait;
    private final boolean mayUpdateScreen;

    BuiltInCommand(int index, String name, String[] args, ISubCommand<?> subCommand, boolean andWait) {
        super(index, name, args, subCommand.getArgumentTypes());
        this.subCommand = subCommand;
        this.andWait = andWait;
        this.mayUpdateScreen = !ArrayUtils.contains((Object[])NO_UPDATE_SCREEN, (Object)subCommand.getName());
    }

    @Override
    public boolean mayUpdateScreen() {
        return this.mayUpdateScreen;
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        try {
            String resultString = SeleniumUtils.convertToString(this.subCommand.execute(context, curArgs));
            if (this.andWait) {
                int timeout = context.getTimeout();
                context.getSubCommandMap().get(WAIT_FOR_PAGE_TO_LOAD).execute(context, Integer.toString(timeout));
            }
            return StringUtils.isNotEmpty((CharSequence)resultString) ? new Success(resultString) : Success.SUCCESS;
        }
        catch (SeleniumException e) {
            return new Failure(e.getMessage().replaceAll("(\r?\n)+", " / "));
        }
    }
}

