/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirefoxDriverFactory
extends WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(FirefoxDriverFactory.class);
    public static final String WEBDRIVER_FIREFOX_BIN = "webdriver.firefox.bin";

    public static void setDriverSpecificCapabilities(DesiredCapabilities caps, DriverOptions driverOptions, boolean isRemote) {
        FirefoxDriverFactory.setFirefoxBinary(caps, driverOptions, isRemote);
        FirefoxDriverFactory.setFirefoxProfile(caps, driverOptions, isRemote);
    }

    private static void setFirefoxBinary(DesiredCapabilities caps, DriverOptions driverOptions, boolean isRemote) {
        FirefoxBinary binary;
        String firefoxBin = System.getProperty(WEBDRIVER_FIREFOX_BIN);
        if (driverOptions.has(DriverOptions.DriverOption.FIREFOX)) {
            firefoxBin = driverOptions.get(DriverOptions.DriverOption.FIREFOX);
            System.setProperty(WEBDRIVER_FIREFOX_BIN, firefoxBin);
        }
        if (isRemote) {
            if (firefoxBin != null) {
                caps.setCapability("firefox_binary", firefoxBin);
                log.info("Firefox binary: {}", (Object)firefoxBin);
            }
            if (driverOptions.has(DriverOptions.DriverOption.CLI_ARGS)) {
                log.warn("Ignore --cli-args with RemoteWebDriver.");
            }
            return;
        }
        try {
            if (firefoxBin != null) {
                File file = new File(firefoxBin);
                if (!file.isFile() || !file.canExecute()) {
                    throw new IllegalArgumentException("Missing Firefox binary: " + firefoxBin);
                }
                binary = new FirefoxBinary(file);
                log.info("Firefox binary: {}", (Object)firefoxBin);
            } else {
                binary = new FirefoxBinary();
            }
        }
        catch (WebDriverException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (driverOptions.has(DriverOptions.DriverOption.CLI_ARGS)) {
            Object[] cliArgs = driverOptions.getCliArgs();
            binary.addCommandLineOptions((String[])cliArgs);
            log.info("Command line arguments: [{}]", (Object)StringUtils.join((Object[])cliArgs, (String)"] ["));
        }
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : driverOptions.getEnvVars().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            binary.setEnvironmentProperty(key, value);
            if (isFirst) {
                log.info("Envrionment variables:");
                isFirst = false;
            }
            log.info("- [{}]=[{}]", (Object)key, (Object)StringEscapeUtils.escapeJava((String)value));
        }
        caps.setCapability("firefox_binary", (Object)binary);
    }

    private static void setFirefoxProfile(DesiredCapabilities caps, DriverOptions driverOptions, boolean isRemote) {
        if (driverOptions.has(DriverOptions.DriverOption.PROFILE) || driverOptions.has(DriverOptions.DriverOption.PROFILE_DIR)) {
            FirefoxProfile profile;
            String profileName = driverOptions.get(DriverOptions.DriverOption.PROFILE);
            String profileDir = driverOptions.get(DriverOptions.DriverOption.PROFILE_DIR);
            if (profileName != null) {
                if (profileDir != null) {
                    throw new IllegalArgumentException("Can't specify both '--profile' and '--profile-dir' at once");
                }
                ProfilesIni allProfiles = new ProfilesIni();
                profile = allProfiles.getProfile(profileName);
                log.info("Firefox profile: {}", (Object)profileName);
            } else {
                File dir = new File(profileDir);
                if (!dir.isDirectory()) {
                    throw new IllegalArgumentException("Missing profile directory: " + profileDir);
                }
                profile = new FirefoxProfile(dir);
                log.info("Firefox profile directory: {}", (Object)profileDir);
            }
            if (isRemote) {
                String json;
                try {
                    json = profile.toJson();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                caps.setCapability("firefox_profile", json);
                log.info("Convert Firefox profile to JSON: {} bytes", (Object)json.length());
            } else {
                caps.setCapability("firefox_profile", (Object)profile);
            }
        }
    }

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        DesiredCapabilities caps = DesiredCapabilities.firefox();
        this.setupProxy(caps, driverOptions);
        caps.merge((Capabilities)driverOptions.getCapabilities());
        FirefoxDriverFactory.setDriverSpecificCapabilities(caps, driverOptions, false);
        FirefoxDriver driver = new FirefoxDriver((Capabilities)caps);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }
}

