/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.subcommand;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.subcommand.AbstractSubCommand;
import org.openqa.selenium.TimeoutException;

public class WaitForCondition
extends AbstractSubCommand<Void> {
    private static final long DEFAULT_INTERVAL = 500L;
    private static final int ARG_SCRIPT = 0;
    private static final int ARG_TIMEOUT = 1;

    public WaitForCondition() {
        super(ArgumentType.VALUE, ArgumentType.VALUE);
    }

    private boolean until(Context context, String script) {
        Object result = context.getEval().eval(context.getWrappedDriver(), script);
        if (result == null) {
            return false;
        }
        if (result instanceof String) {
            return !((String)result).isEmpty();
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return true;
    }

    @Override
    public Void execute(Context context, String ... args) {
        String script = args[0];
        long timeout = Long.valueOf(args[1]);
        long end = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < end) {
            if (this.until(context, script)) {
                return null;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new TimeoutException("Failed to resolve " + script);
    }
}

