/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.locator;

import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.ElementFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.vmi.selenium.selenese.locator.AdditionalHandler;
import jp.vmi.selenium.selenese.locator.CSSHandler;
import jp.vmi.selenium.selenese.locator.DomHandler;
import jp.vmi.selenium.selenese.locator.IdHandler;
import jp.vmi.selenium.selenese.locator.IdentifierHandler;
import jp.vmi.selenium.selenese.locator.LinkHandler;
import jp.vmi.selenium.selenese.locator.Locator;
import jp.vmi.selenium.selenese.locator.LocatorHandler;
import jp.vmi.selenium.selenese.locator.NameHandler;
import jp.vmi.selenium.selenese.locator.OptionIdHandler;
import jp.vmi.selenium.selenese.locator.OptionIndexHandler;
import jp.vmi.selenium.selenese.locator.OptionLabelHandler;
import jp.vmi.selenium.selenese.locator.OptionLocatorHandler;
import jp.vmi.selenium.selenese.locator.OptionValueHandler;
import jp.vmi.selenium.selenese.locator.XPathHandler;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverElementFinder
extends ElementFinder {
    private static final Logger log = LoggerFactory.getLogger(WebDriverElementFinder.class);
    private final Map<String, LocatorHandler> handlerMap = new HashMap<String, LocatorHandler>();
    private final Map<String, OptionLocatorHandler> optionHandlerMap = new HashMap<String, OptionLocatorHandler>();
    private final List<Locator> currentFrameLocators = new ArrayList<Locator>();
    private WebDriver noParentFrameWebDriver = null;

    public static String convertToOptionLocatorWithParent(String parentLocator, String optionLocator) {
        return parentLocator + "\u0000" + optionLocator;
    }

    public WebDriverElementFinder() {
        this.registerHandler(new IdentifierHandler());
        this.registerHandler(new IdHandler());
        this.registerHandler(new NameHandler());
        this.registerHandler(new DomHandler());
        this.registerHandler(new XPathHandler());
        this.registerHandler(new LinkHandler());
        this.registerHandler(new CSSHandler());
        this.registerOptionHandler(new OptionLabelHandler());
        this.registerOptionHandler(new OptionIdHandler());
        this.registerOptionHandler(new OptionIndexHandler());
        this.registerOptionHandler(new OptionValueHandler());
    }

    public WebDriverElementFinder registerHandler(LocatorHandler handler) {
        this.handlerMap.put(handler.locatorType(), handler);
        return this;
    }

    public WebDriverElementFinder registerOptionHandler(OptionLocatorHandler handler) {
        this.optionHandlerMap.put(handler.optionLocatorType(), handler);
        return this;
    }

    public void add(String strategyName, String implementation) {
        this.registerHandler(new AdditionalHandler(strategyName, implementation));
    }

    public WebElement superFindElement(WebDriver driver, String locator) {
        return super.findElement(driver, locator);
    }

    private void switchToFrame(WebDriver driver, List<Locator> plocs) {
        driver.switchTo().defaultContent();
        try {
            ArrayList<Locator> selectedFrameLocators = new ArrayList<Locator>();
            for (Locator ploc : plocs) {
                for (int index : ploc.frameIndexList) {
                    driver.switchTo().frame(index);
                }
                if (!ploc.isTypeIndex()) {
                    WebElement frame = this.findElementsInternal(driver, ploc, selectedFrameLocators).get(0);
                    driver.switchTo().frame(frame);
                }
                selectedFrameLocators.add(ploc);
            }
        }
        catch (RuntimeException e) {
            if (e instanceof NotFoundException || e.getCause() instanceof NotFoundException) {
                if (plocs == this.currentFrameLocators) {
                    log.warn("The selected frame has disapeared: {}", (Object)StringUtils.join(plocs, (char)'/'));
                    log.warn("Reset selected frame.");
                }
                driver.switchTo().defaultContent();
                plocs.clear();
            }
            throw e;
        }
    }

    private void pushFrame(WebDriver driver, Locator ploc, int index) {
        driver.switchTo().frame(index);
        ploc.frameIndexList.addLast(index);
    }

    private boolean isParentFrameUnsupported(RuntimeException e) {
        return e instanceof UnsupportedCommandException || e instanceof WebDriverException && StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"switchToParentFrame");
    }

    private void popFrame(WebDriver driver, Locator ploc, List<Locator> selectedFrameLocators) {
        ploc.frameIndexList.pollLast();
        if (this.noParentFrameWebDriver != driver) {
            try {
                driver.switchTo().parentFrame();
                return;
            }
            catch (RuntimeException e) {
                if (!this.isParentFrameUnsupported(e)) {
                    throw e;
                }
                log.warn("{} does not support \"parentFrame\".", (Object)driver.getClass().getSimpleName());
                this.noParentFrameWebDriver = driver;
            }
        }
        this.switchToFrame(driver, selectedFrameLocators);
        for (int index : ploc.frameIndexList) {
            driver.switchTo().frame(index);
        }
    }

    private List<WebElement> findElementsByLocator(LocatorHandler handler, WebDriver driver, Locator ploc, List<Locator> selectedFrameLocators) {
        List<WebElement> result = handler.handle(driver, ploc.arg);
        if (!result.isEmpty()) {
            return result;
        }
        int iframeCount = driver.findElements(By.tagName((String)"iframe")).size();
        for (int index = 0; index < iframeCount; ++index) {
            this.pushFrame(driver, ploc, index);
            result = this.findElementsByLocator(handler, driver, ploc, selectedFrameLocators);
            if (result != null) {
                return result;
            }
            this.popFrame(driver, ploc, selectedFrameLocators);
        }
        int frameCount = driver.findElements(By.tagName((String)"frame")).size();
        for (int index = 0; index < frameCount; ++index) {
            this.pushFrame(driver, ploc, index);
            result = this.findElementsByLocator(handler, driver, ploc, selectedFrameLocators);
            if (result != null) {
                return result;
            }
            this.popFrame(driver, ploc, selectedFrameLocators);
        }
        return null;
    }

    private List<WebElement> filterElementsByOptionLocator(List<WebElement> elements, String option) {
        String arg;
        String type;
        if (option == null) {
            return elements;
        }
        String[] pair = option.split("=", 2);
        if (pair.length == 1) {
            type = "label";
            arg = option;
        } else {
            type = pair[0];
            arg = pair[1];
        }
        OptionLocatorHandler handler = this.optionHandlerMap.get(type);
        if (handler == null) {
            throw new UnsupportedOperationException("Unknown option locator type: " + option);
        }
        ArrayList<WebElement> result = new ArrayList<WebElement>();
        for (WebElement element : elements) {
            result.addAll(handler.handle(element, arg));
        }
        return result;
    }

    private List<WebElement> findElementsInternal(WebDriver driver, Locator ploc, List<Locator> selectedFrameLocators) {
        LocatorHandler handler = this.handlerMap.get(ploc.type);
        if (handler == null) {
            throw new UnsupportedOperationException("Unknown locator type: " + ploc);
        }
        List<WebElement> elements = this.findElementsByLocator(handler, driver, ploc, selectedFrameLocators);
        if (elements == null) {
            throw new SeleniumException("Element " + ploc + " not found", (Exception)new NoSuchElementException(ploc.toString()));
        }
        return this.filterElementsByOptionLocator(elements, ploc.option);
    }

    public List<WebElement> findElements(WebDriver driver, String locator, List<Locator> selectedFrameLocators) {
        Locator ploc = new Locator(locator);
        if (ploc.isTypeRelative()) {
            if (ploc.isRelativeTop()) {
                driver.switchTo().defaultContent();
            } else if (ploc.isRelativeParent()) {
                int size = selectedFrameLocators.size();
                if (size > 0) {
                    this.switchToFrame(driver, selectedFrameLocators.subList(0, size - 1));
                } else {
                    log.warn("The current selected frame is top level. \"" + ploc + "\" is ignored.");
                }
            } else {
                throw new SeleniumException("Invalid \"relative\" locator argument: " + ploc.arg);
            }
            return Arrays.asList(driver.switchTo().activeElement());
        }
        if (ploc.isTypeIndex()) {
            int index;
            this.switchToFrame(driver, selectedFrameLocators);
            List frames = driver.findElements(By.tagName((String)"iframe"));
            if (frames.isEmpty()) {
                frames = driver.findElements(By.tagName((String)"frame"));
            }
            if ((index = ploc.getIndex()) < 0 || index >= frames.size()) {
                throw new SeleniumException("\"index\" locator argument is out of range: " + ploc.arg);
            }
            return Arrays.asList((WebElement)frames.get(index));
        }
        this.switchToFrame(driver, selectedFrameLocators);
        return this.findElementsInternal(driver, ploc, selectedFrameLocators);
    }

    public List<WebElement> findElements(WebDriver driver, String locator) {
        return this.findElements(driver, locator, this.currentFrameLocators);
    }

    public WebElement findElement(WebDriver driver, String locator, List<Locator> selectedFrameLocators) {
        return this.findElements(driver, locator, selectedFrameLocators).get(0);
    }

    public WebElement findElement(WebDriver driver, String locator) {
        return this.findElements(driver, locator).get(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void selectFrame(WebDriver driver, String locator) {
        Locator ploc = new Locator(locator);
        if (ploc.isTypeRelative()) {
            if (ploc.isRelativeTop()) {
                driver.switchTo().defaultContent();
                this.currentFrameLocators.clear();
                return;
            } else {
                if (!ploc.isRelativeParent()) throw new SeleniumException("Invalid frame locator: " + ploc);
                int size = this.currentFrameLocators.size();
                if (size > 0) {
                    this.currentFrameLocators.remove(size - 1);
                    this.switchToFrame(driver, this.currentFrameLocators);
                    return;
                } else {
                    log.warn("The current selected frame is top level. \"" + ploc + "\" is ignored.");
                }
            }
            return;
        }
        if (ploc.isTypeIndex()) {
            this.switchToFrame(driver, this.currentFrameLocators);
            int index = ploc.getIndex();
            try {
                driver.switchTo().frame(index);
            }
            catch (NoSuchFrameException e) {
                throw new SeleniumException((Exception)((Object)e));
            }
            ploc.frameIndexList.add(index);
            this.currentFrameLocators.add(ploc);
            return;
        }
        this.switchToFrame(driver, this.currentFrameLocators);
        WebElement frame = this.findElementsInternal(driver, ploc, this.currentFrameLocators).get(0);
        driver.switchTo().frame(frame);
        this.currentFrameLocators.add(ploc);
    }

    public List<Locator> getCurrentFrameLocators() {
        return new ArrayList<Locator>(this.currentFrameLocators);
    }
}

