/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.locator;

import com.thoughtworks.selenium.SeleniumException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Locator {
    public static final String IDENTIFIER = "identifier";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String DOM = "dom";
    public static final String XPATH = "xpath";
    public static final String LINK = "link";
    public static final String CSS = "css";
    public static final String RELATIVE = "relative";
    public static final String INDEX = "index";
    public static final String RELATIVE_TOP = "relative=top";
    public static final String RELATIVE_PARENT = "relative=parent";
    public static final String OPTION_LOCATOR_SEPARATOR = "\u0000";
    private static final Pattern LOCATORS_RE = Pattern.compile("(\\w+)=(.*)|(document\\..*)|(//.*)");
    private static final int LOCATOR_TYPE = 1;
    private static final int LOCATOR_ARG = 2;
    private static final int DOM_LOCATOR = 3;
    private static final int XPATH_LOCATOR = 4;
    public final String locator;
    public final String type;
    public final String arg;
    public final String option;
    public final Deque<Integer> frameIndexList = new ArrayDeque<Integer>();

    private static String formatLocator(String locator, String option) {
        return option == null ? locator : locator + " (" + option + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Locator(String locator) {
        String[] pair = locator.split(OPTION_LOCATOR_SEPARATOR, 2);
        this.locator = pair[0];
        this.option = pair.length == 2 ? pair[1] : null;
        Matcher matcher = LOCATORS_RE.matcher(this.locator);
        if (matcher.matches()) {
            String type = matcher.group(1);
            String arg = matcher.group(2);
            if (StringUtils.isNotEmpty((CharSequence)type)) {
                try {
                    this.type = type.toLowerCase();
                }
                catch (IllegalArgumentException e) {
                    throw new UnsupportedOperationException("Unknown locator type: " + Locator.formatLocator(this.locator, this.option), e);
                }
                this.arg = arg;
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)matcher.group(3))) {
                this.type = DOM;
                this.arg = this.locator;
                return;
            } else {
                if (!StringUtils.isNotEmpty((CharSequence)matcher.group(4))) throw new UnsupportedOperationException("Unknown locator type: " + Locator.formatLocator(this.locator, this.option));
                this.type = XPATH;
                this.arg = this.locator;
            }
            return;
        }
        this.type = IDENTIFIER;
        this.arg = this.locator;
    }

    public boolean isTypeRelative() {
        return RELATIVE.equals(this.type);
    }

    public boolean isTypeIndex() {
        return INDEX.equals(this.type);
    }

    public boolean isRelativeTop() {
        return RELATIVE_TOP.equals(this.locator);
    }

    public boolean isRelativeParent() {
        return RELATIVE_PARENT.equals(this.locator);
    }

    public int getIndex() {
        try {
            return Integer.parseInt(this.arg);
        }
        catch (NumberFormatException e) {
            throw new SeleniumException("Invalid \"" + this.type + "\" locator argument: " + this.arg, (Exception)e);
        }
    }

    public String toString() {
        return Locator.formatLocator(this.locator, this.option);
    }
}

