/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.inject;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.ScreenshotHandler;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.result.Result;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.openqa.selenium.WebDriverException;

public class ScreenshotInterceptor
implements MethodInterceptor {
    private static final int CONTEXT = 0;
    private static final int COMMAND = 1;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] args = invocation.getArguments();
        Context context = (Context)args[0];
        ICommand command = (ICommand)args[1];
        Result result = (Result)invocation.proceed();
        if (context instanceof ScreenshotHandler && command.mayUpdateScreen()) {
            ScreenshotHandler handler = (ScreenshotHandler)((Object)context);
            String baseName = context.getCurrentTestCase().getBaseName();
            try {
                command.addScreenshot(handler.takeScreenshotAll(baseName, command.getIndex()), "all");
                if (!result.isSuccess()) {
                    command.addScreenshot(handler.takeScreenshotOnFail(baseName, command.getIndex()), "fail");
                }
            }
            catch (WebDriverException webDriverException) {
                // empty catch block
            }
        }
        return result;
    }
}

