/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.config;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.config.IConfig;
import jp.vmi.selenium.selenese.config.SeleneseRunnerOptions;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultConfig
implements IConfig {
    private final CommandLine cli;
    private final Map<String, List<String>> config = new HashMap<String, List<String>>();
    private static final Pattern RE = Pattern.compile("#.*|([\\w\\-]+)\\s*:\\s*(.*?)\\s*|\\s+(.*?)\\s*");

    public DefaultConfig(String ... args) {
        this(new SeleneseRunnerOptions().parseCommandLine(args));
    }

    public DefaultConfig(CommandLine cli) {
        this.cli = cli;
        String file = cli.getOptionValue("config");
        if (file != null) {
            this.loadFrom(file);
        }
    }

    @Override
    public String[] getArgs() {
        return this.cli.getArgs();
    }

    private boolean cliHasOption(String opt) {
        return this.cli != null && this.cli.hasOption(opt);
    }

    public void loadFrom(String file) {
        BufferedReader r = null;
        try {
            String line;
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));
            int cnt = 0;
            String currentKey = null;
            ArrayList<String> values = null;
            while ((line = r.readLine()) != null) {
                String value;
                ++cnt;
                if (line.isEmpty()) continue;
                Matcher matcher = RE.matcher(line);
                if (!matcher.matches()) {
                    throw new RuntimeException(file + ":" + cnt + ": Invalid format: " + line);
                }
                String key = matcher.group(1);
                if (key != null) {
                    currentKey = key;
                    values = new ArrayList<String>();
                    value = matcher.group(2);
                    if (StringUtils.isNotEmpty((CharSequence)value)) {
                        values.add(value);
                    }
                    this.config.put(key, values);
                    continue;
                }
                if (currentKey == null || !StringUtils.isNotEmpty((CharSequence)(value = matcher.group(3)))) continue;
                values.add(value);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(r);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)r);
    }

    @Override
    public boolean hasOption(String opt) {
        return this.cliHasOption(opt) || this.config.containsKey(opt);
    }

    @Override
    public String getOptionValue(String opt) {
        return this.getOptionValue(opt, null);
    }

    @Override
    public String getOptionValue(String opt, String defaultValue) {
        if (this.cliHasOption(opt)) {
            return this.cli.getOptionValue(opt);
        }
        List<String> values = this.config.get(opt);
        if (values == null || values.isEmpty()) {
            return defaultValue;
        }
        return values.get(0);
    }

    @Override
    public String[] getOptionValues(String opt) {
        if (this.cliHasOption(opt)) {
            return this.cli.getOptionValues(opt);
        }
        List<String> values = this.config.get(opt);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    public boolean getOptionValueAsBoolean(String opt) {
        if (this.cliHasOption(opt)) {
            return true;
        }
        List<String> values = this.config.get(opt);
        return values != null && !values.isEmpty() && BooleanUtils.toBoolean((String)values.get(0));
    }
}

