/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.StartLoop;

public class CommandSequence {
    private static final char SEPARATOR = '-';
    private final CommandSequence parent;
    private final List<Counter> counters = new ArrayList<Counter>();
    private Counter tail;

    public CommandSequence(CommandSequence parent) {
        this.parent = parent;
        this.tail = new Counter(StartLoop.NO_START_LOOP, 0);
        this.counters.add(this.tail);
    }

    private static List<StartLoop> getListOfStartLoop(ICommand command) {
        StartLoop startLoop = command.getStartLoop();
        List<Object> result = startLoop == StartLoop.NO_START_LOOP ? new ArrayList() : CommandSequence.getListOfStartLoop((ICommand)((Object)startLoop));
        result.add(startLoop);
        return result;
    }

    public void increment(ICommand command) {
        if (this.tail.startLoop == command.getStartLoop()) {
            ++this.tail.count;
        } else {
            Iterator<Counter> citer = this.counters.iterator();
            ListIterator<StartLoop> siter = CommandSequence.getListOfStartLoop(command).listIterator();
            int index = 0;
            while (citer.hasNext() && siter.hasNext()) {
                if (citer.next().startLoop != siter.next()) {
                    siter.previous();
                    break;
                }
                ++index;
            }
            if (index < this.counters.size()) {
                this.counters.subList(index, this.counters.size()).clear();
            }
            ++this.counters.get((int)(this.counters.size() - 1)).count;
            while (siter.hasNext()) {
                StartLoop s = siter.next();
                this.counters.add(new Counter(s, 1));
            }
            this.tail = this.counters.get(this.counters.size() - 1);
        }
        if (command instanceof StartLoop) {
            this.tail = new Counter((StartLoop)((Object)command), 1);
            this.counters.add(this.tail);
        }
    }

    public int getLevel() {
        return (this.parent != null ? this.parent.getLevel() : 0) + this.counters.size();
    }

    private StringBuilder appendString(StringBuilder result) {
        if (result.length() > 0) {
            result.append('-');
        }
        Iterator<Counter> iter = this.counters.iterator();
        result.append(iter.next().count);
        while (iter.hasNext()) {
            result.append('-').append(iter.next().count);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getLevel() * 4);
        if (this.parent != null) {
            this.parent.appendString(result);
        }
        return this.appendString(result).toString();
    }

    private static class Counter {
        public StartLoop startLoop;
        public int count;

        public Counter(StartLoop startLoop, int count) {
            this.startLoop = startLoop;
            this.count = count;
        }
    }
}

