/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.phantomjs;

import java.io.File;
import java.util.Collection;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.browserlaunchers.Proxies;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPhantomJSDriverServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(CustomPhantomJSDriverServiceFactory.class);
    private static final String PHANTOMJS_DOC_LINK = "https://github.com/ariya/phantomjs/wiki";
    private static final String PHANTOMJS_DOWNLOAD_LINK = "http://phantomjs.org/download.html";
    private static final String GHOSTDRIVER_DOC_LINK = "https://github.com/detro/ghostdriver/blob/master/README.md";
    private static final String GHOSTDRIVER_DOWNLOAD_LINK = "https://github.com/detro/ghostdriver/downloads";

    public static PhantomJSDriverService createDefaultService(Capabilities desiredCapabilities) {
        Proxy proxy = null;
        if (desiredCapabilities != null) {
            proxy = Proxies.extractProxy((Capabilities)desiredCapabilities);
        }
        File phantomjsfile = PhantomJSDriverService.findPhantomJS((Capabilities)desiredCapabilities, (String)PHANTOMJS_DOC_LINK, (String)PHANTOMJS_DOWNLOAD_LINK);
        File ghostDriverfile = PhantomJSDriverService.findGhostDriver((Capabilities)desiredCapabilities, (String)GHOSTDRIVER_DOC_LINK, (String)GHOSTDRIVER_DOWNLOAD_LINK);
        return new PhantomJSDriverService.Builder().usingPhantomJSExecutable(phantomjsfile).usingGhostDriver(ghostDriverfile).usingAnyFreePort().withProxy(proxy).usingCommandLineArguments(CustomPhantomJSDriverServiceFactory.findCLIArgumentsFromCaps(desiredCapabilities, "phantomjs.cli.args")).usingGhostDriverCommandLineArguments(CustomPhantomJSDriverServiceFactory.findCLIArgumentsFromCaps(desiredCapabilities, "phantomjs.ghostdriver.cli.args")).build();
    }

    private static String[] findCLIArgumentsFromCaps(Capabilities desiredCapabilities, String capabilityName) {
        Object cap;
        if (desiredCapabilities != null && (cap = desiredCapabilities.getCapability(capabilityName)) != null) {
            if (cap instanceof String[]) {
                return (String[])cap;
            }
            if (cap instanceof Collection) {
                try {
                    Collection capCollection = (Collection)cap;
                    return capCollection.toArray(new String[capCollection.size()]);
                }
                catch (Exception e) {
                    log.warn(String.format("Unable to set Capability '%s' as it was neither a String[] or a Collection<String>", capabilityName));
                }
            }
        }
        return new String[0];
    }
}

