/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.io.File;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.CustomPhantomJSDriverServiceFactory;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomJSDriverFactory
extends WebDriverFactory {
    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        DesiredCapabilities caps = this.setupProxy(DesiredCapabilities.phantomjs(), driverOptions);
        if (driverOptions.has(DriverOptions.DriverOption.PHANTOMJS)) {
            File binary = new File(driverOptions.get(DriverOptions.DriverOption.PHANTOMJS));
            if (!binary.canExecute()) {
                throw new IllegalArgumentException("Missing PhantomJS binary: " + binary);
            }
            caps.setCapability("phantomjs.binary.path", binary.getPath());
        }
        caps.merge((Capabilities)driverOptions.getCapabilities());
        PhantomJSDriverService service = CustomPhantomJSDriverServiceFactory.createDefaultService((Capabilities)caps);
        PhantomJSDriver driver = new PhantomJSDriver(service, (Capabilities)caps);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }

    @Override
    protected Dimension getDefaultWindowSize(WebDriver driver) {
        return new Dimension(1024, 768);
    }
}

