/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.io.File;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.apache.commons.exec.OS;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;

public class IEDriverFactory
extends WebDriverFactory {
    private static final String IE_DRIVER_SERVER_EXE = "IEDriverServer.exe";

    @Override
    public boolean isProxySupported() {
        return false;
    }

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        File executable;
        if (!OS.isFamilyWindows()) {
            throw new UnsupportedOperationException("Unsupported platform: " + Platform.getCurrent());
        }
        DesiredCapabilities caps = this.setupProxy(DesiredCapabilities.internetExplorer(), driverOptions);
        if (driverOptions.has(DriverOptions.DriverOption.IEDRIVER)) {
            executable = new File(driverOptions.get(DriverOptions.DriverOption.IEDRIVER));
            if (!executable.canExecute()) {
                throw new IllegalArgumentException("Missing IEDriverServer.exe: " + executable);
            }
        } else {
            executable = PathUtils.searchExecutableFile(IE_DRIVER_SERVER_EXE);
            if (executable == null) {
                throw new IllegalStateException("Missing IEDriverServer.exe in PATH");
            }
        }
        InternetExplorerDriverService service = new InternetExplorerDriverService.Builder().usingAnyFreePort().usingDriverExecutable(executable).build();
        caps.merge((Capabilities)driverOptions.getCapabilities());
        InternetExplorerDriver driver = new InternetExplorerDriver(service, (Capabilities)caps);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }
}

