/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.io.File;
import java.util.Map;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxDriverFactory
extends WebDriverFactory {
    public static final String WEBDRIVER_FIREFOX_BIN = "webdriver.firefox.bin";

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        FirefoxProfile profile;
        FirefoxBinary binary;
        File file;
        String path = System.getProperty(WEBDRIVER_FIREFOX_BIN);
        if (!(path == null || (file = new File(path)).isFile() && file.canExecute())) {
            throw new IllegalArgumentException("Executable file does not exist: " + path + " defined by \"" + WEBDRIVER_FIREFOX_BIN + "\"");
        }
        try {
            binary = new FirefoxBinary();
        }
        catch (WebDriverException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        for (Map.Entry<String, String> entry : this.getEnvironmentVariables().entrySet()) {
            binary.setEnvironmentProperty(entry.getKey(), entry.getValue());
        }
        String profileName = driverOptions.get(DriverOptions.DriverOption.PROFILE);
        String dir = driverOptions.get(DriverOptions.DriverOption.PROFILE_DIR);
        if (profileName != null) {
            if (dir != null) {
                throw new IllegalArgumentException("Can't specify both '--profile' and '--profile-dir' at once");
            }
            ProfilesIni allProfiles = new ProfilesIni();
            profile = allProfiles.getProfile(profileName);
        } else if (dir != null) {
            File file2 = new File(dir);
            if (!file2.isDirectory()) {
                throw new IllegalArgumentException("Missing profile directory: " + dir);
            }
            profile = new FirefoxProfile(new File(dir));
        } else {
            profile = new FirefoxProfile();
        }
        DesiredCapabilities caps = this.setupProxy(DesiredCapabilities.firefox(), driverOptions);
        caps.merge((Capabilities)driverOptions.getCapabilities());
        FirefoxDriver driver = new FirefoxDriver(binary, profile, (Capabilities)caps);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }
}

