/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.io.File;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeDriverFactory
extends WebDriverFactory {
    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        File executable;
        if (driverOptions.has(DriverOptions.DriverOption.CHROMEDRIVER)) {
            executable = new File(driverOptions.get(DriverOptions.DriverOption.CHROMEDRIVER));
            if (!executable.canExecute()) {
                throw new IllegalArgumentException("Missing ChromeDriver: " + executable);
            }
        } else {
            executable = PathUtils.searchExecutableFile("chromedriver");
            if (executable == null) {
                throw new IllegalStateException("Missing ChromeDriver in PATH");
            }
        }
        ChromeDriverService service = new ChromeDriverService.Builder().usingDriverExecutable(executable).usingAnyFreePort().withEnvironment(this.getEnvironmentVariables()).build();
        DesiredCapabilities caps = DesiredCapabilities.chrome();
        ChromeOptions options = new ChromeOptions();
        if (driverOptions.has(DriverOptions.DriverOption.PROXY)) {
            options.addArguments(new String[]{"--proxy-server=http://" + driverOptions.get(DriverOptions.DriverOption.PROXY)});
        }
        caps.setCapability("chromeOptions", (Object)options);
        caps.merge((Capabilities)driverOptions.getCapabilities());
        ChromeDriver driver = new ChromeDriver(service, (Capabilities)caps);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }
}

