/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.subcommand;

import java.util.ArrayList;
import java.util.List;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.subcommand.AbstractSubCommand;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class GetSelected
extends AbstractSubCommand<Object> {
    private static final int ARG_LOCATOR = 0;
    private final String name;
    private final Type type;
    private final boolean isMultiple;

    public GetSelected(Type type, boolean isMultiple) {
        super(ArgumentType.LOCATOR);
        this.name = type.getSubCommandName(isMultiple);
        this.type = type;
        this.isMultiple = isMultiple;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object execute(Context context, String ... args) {
        String locator = args[0];
        WebElement select = context.getElementFinder().findElement(context.getWrappedDriver(), locator);
        if (select == null) {
            return null;
        }
        List options = select.findElements(By.tagName((String)"option"));
        ArrayList<Object> found = new ArrayList<Object>();
        int i = -1;
        block6: for (WebElement option : options) {
            ++i;
            if (!option.isSelected()) continue;
            switch (this.type) {
                case LABEL: {
                    found.add(option.getText());
                    continue block6;
                }
                case VALUE: {
                    found.add(option.getAttribute("value"));
                    continue block6;
                }
                case INDEX: {
                    found.add(i);
                    continue block6;
                }
                case ID: {
                    found.add(option.getAttribute("id"));
                    continue block6;
                }
            }
            throw new UnsupportedOperationException((Object)((Object)this.type) + " is not implemented.");
        }
        if (this.isMultiple) {
            return found;
        }
        return found.isEmpty() ? null : found.get(0);
    }

    public static enum Type {
        LABEL,
        VALUE,
        INDEX,
        ID;


        private String getSubCommandName(boolean isMultiple) {
            String plural;
            String prefix = StringUtils.uncapitalize((String)GetSelected.class.getSimpleName());
            String suffix = StringUtils.capitalize((String)this.name().toLowerCase());
            if (isMultiple) {
                switch (this) {
                    case INDEX: {
                        plural = "es";
                        break;
                    }
                    default: {
                        plural = "s";
                        break;
                    }
                }
            } else {
                plural = "";
            }
            return prefix + suffix + plural;
        }
    }
}

