/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.junit.result;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jp.vmi.junit.result.Error;
import jp.vmi.junit.result.Failure;
import jp.vmi.junit.result.ITestCase;
import jp.vmi.junit.result.ObjectFactory;
import jp.vmi.junit.result.SkippedAdapter;
import jp.vmi.junit.result.TestResult;
import jp.vmi.selenium.selenese.utils.LogRecorder;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"skipped", "error", "failure", "systemOut", "systemErr"})
public class TestCaseResult
extends TestResult<ITestCase> {
    private static final String NL = System.getProperty("line.separator");
    @XmlTransient
    private boolean success = false;
    @XmlElement
    private Error error = null;
    @XmlElement
    private Failure failure = null;

    public void setSuccess() {
        this.success = true;
    }

    public void setError(String message, String value) {
        this.error = ObjectFactory.factory.createError(message, value);
    }

    public void setFailure(String message, String value) {
        this.failure = ObjectFactory.factory.createFailure(message, value);
    }

    public int getErrors() {
        return this.error != null ? 1 : 0;
    }

    public int getFailures() {
        return this.failure != null ? 1 : 0;
    }

    @XmlElementRef
    @XmlJavaTypeAdapter(value=SkippedAdapter.class)
    public Integer getSkipped() {
        return !this.success && this.error == null && this.failure == null ? 1 : 0;
    }

    @XmlElement(name="system-out")
    public String getSystemOut() {
        List<LogRecorder.LogMessage> msgs = ((ITestCase)this.testTarget).getLogRecorder().getMessages();
        return msgs.size() != 0 ? StringUtils.join(msgs, (String)NL) : null;
    }

    @XmlElement(name="system-err")
    public String getSystemErr() {
        List<LogRecorder.LogMessage> msgs = ((ITestCase)this.testTarget).getLogRecorder().getErrorMessages();
        return msgs.size() != 0 ? StringUtils.join(msgs, (String)NL) : null;
    }
}

