/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.html.result;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlEscapeRenderer
implements NamedRenderer {
    private static final Pattern RE = Pattern.compile("[<>&\"'\\\\]|\r?\n|\r");
    private static final Map<String, String> ESC_MAP = new HashMap<String, String>();

    public RenderFormatInfo getFormatInfo() {
        return null;
    }

    public String getName() {
        return "h";
    }

    public Class<?>[] getSupportedClasses() {
        return new Class[]{Object.class};
    }

    public String render(Object o, String format, Locale locale) {
        StringBuilder result = new StringBuilder();
        String s = o.toString();
        Matcher matcher = RE.matcher(s);
        int index = 0;
        while (matcher.find(index)) {
            int start = matcher.start();
            if (index < start) {
                result.append(s, index, start);
            }
            result.append(ESC_MAP.get(matcher.group()));
            index = matcher.end();
        }
        if (index < s.length()) {
            result.append(s, index, s.length());
        }
        return result.toString();
    }

    static {
        ESC_MAP.put("<", "&lt;");
        ESC_MAP.put(">", "&gt;");
        ESC_MAP.put("&", "&amp;");
        ESC_MAP.put("\"", "&quot;");
        ESC_MAP.put("'", "&#39;");
        ESC_MAP.put("\\", "&#92;");
        ESC_MAP.put("\r\n", "<br>\r\n");
        ESC_MAP.put("\n", "<br>\n");
        ESC_MAP.put("\r", "<br>\r");
    }
}

