/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.util.HashMap;
import java.util.Map;
import jp.vmi.selenium.webdriver.DriverOptions;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    Map<String, String> environmentVariables = new HashMap<String, String>();

    public boolean isProxySupported() {
        return true;
    }

    protected DesiredCapabilities setupProxy(DesiredCapabilities caps, DriverOptions driverOptions) {
        if (driverOptions.has(DriverOptions.DriverOption.PROXY)) {
            if (!this.isProxySupported()) {
                log.warn("No support proxy with {}. Please set proxy to browser configuration in advance.", (Object)this.getClass().getSimpleName().replaceFirst("Factory$", ""));
                return caps;
            }
            Proxy proxy = new Proxy();
            proxy.setProxyType(Proxy.ProxyType.MANUAL);
            String ps = driverOptions.get(DriverOptions.DriverOption.PROXY);
            proxy.setHttpProxy(ps).setSslProxy(ps).setFtpProxy(ps);
            if (driverOptions.has(DriverOptions.DriverOption.NO_PROXY)) {
                proxy.setNoProxy(driverOptions.get(DriverOptions.DriverOption.NO_PROXY));
            }
            caps.setCapability("proxy", (Object)proxy);
        }
        return caps;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public abstract WebDriver newInstance(DriverOptions var1);

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

