/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.net.MalformedURLException;
import java.net.URL;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWebDriverFactory
extends WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(RemoteWebDriverFactory.class);

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        URL url;
        DesiredCapabilities caps = this.setupProxy(DesiredCapabilities.htmlUnit(), driverOptions);
        if (driverOptions.has(DriverOptions.DriverOption.REMOTE_BROWSER)) {
            caps.setBrowserName(driverOptions.get(DriverOptions.DriverOption.REMOTE_BROWSER));
        }
        if (driverOptions.has(DriverOptions.DriverOption.REMOTE_PLATFORM)) {
            caps.setCapability("platform", driverOptions.get(DriverOptions.DriverOption.REMOTE_PLATFORM));
        }
        if (driverOptions.has(DriverOptions.DriverOption.REMOTE_VERSION)) {
            caps.setCapability("version", driverOptions.get(DriverOptions.DriverOption.REMOTE_VERSION));
        }
        if (driverOptions.has(DriverOptions.DriverOption.REMOTE_URL)) {
            try {
                url = new URL(driverOptions.get(DriverOptions.DriverOption.REMOTE_URL));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid --remote-url: " + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Require --remote-url to know where to connect to");
        }
        caps.merge((Capabilities)driverOptions.getCapabilities());
        RemoteWebDriver driver = new RemoteWebDriver(url, (Capabilities)caps);
        log.info("Session ID: " + driver.getSessionId());
        return driver;
    }
}

