/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.io.File;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.apache.commons.lang3.math.NumberUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.CustomPhantomJSDriverServiceFactory;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhantomJSDriverFactory
extends WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(PhantomJSDriverFactory.class);
    private static final int DEFAULT_WIDTH = 1024;
    private static final int DEFAULT_HEIGHT = 768;

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        DesiredCapabilities caps = this.setupProxy(DesiredCapabilities.phantomjs(), driverOptions);
        if (driverOptions.has(DriverOptions.DriverOption.PHANTOMJS)) {
            File binary = new File(driverOptions.get(DriverOptions.DriverOption.PHANTOMJS));
            if (!binary.canExecute()) {
                throw new IllegalArgumentException("Missing PhantomJS binary: " + binary);
            }
            caps.setCapability("phantomjs.binary.path", binary.getPath());
        }
        caps.merge((Capabilities)driverOptions.getCapabilities());
        PhantomJSDriverService service = CustomPhantomJSDriverServiceFactory.createDefaultService((Capabilities)caps);
        PhantomJSDriver driver = new PhantomJSDriver(service, (Capabilities)caps);
        int width = NumberUtils.toInt((String)driverOptions.get(DriverOptions.DriverOption.WIDTH), (int)1024);
        int height = NumberUtils.toInt((String)driverOptions.get(DriverOptions.DriverOption.HEIGHT), (int)768);
        driver.manage().window().setSize(new Dimension(width, height));
        log.info("phantomjs screen size: {}x{}", (Object)width, (Object)height);
        return driver;
    }
}

