/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.DesiredCapabilities;

public class DriverOptions {
    private final IdentityHashMap<DriverOption, String> map = Maps.newIdentityHashMap();
    private final DesiredCapabilities caps = new DesiredCapabilities();

    public DriverOptions() {
    }

    public DriverOptions(CommandLine cli) {
        for (DriverOption opt : DriverOption.values()) {
            String key = opt.name().toLowerCase().replace('_', '-');
            if (opt != DriverOption.DEFINE) {
                this.set(opt, cli.getOptionValue(key));
                continue;
            }
            this.addDefinitions(cli.getOptionValues("define"));
        }
    }

    public String get(DriverOption opt) {
        if (opt == DriverOption.DEFINE) {
            throw new IllegalArgumentException("Need to use DriverOptions#getCapabilities() instead of get(DriverOption.DEFINE).");
        }
        return this.map.get((Object)opt);
    }

    public boolean has(DriverOption opt) {
        if (opt != DriverOption.DEFINE) {
            return this.map.containsKey((Object)opt);
        }
        return !this.caps.asMap().isEmpty();
    }

    public DriverOptions set(DriverOption opt, String ... values) {
        if (opt != DriverOption.DEFINE) {
            if (values.length != 1) {
                throw new IllegalArgumentException("Need to pass only a single value for " + (Object)((Object)opt));
            }
            if (values[0] != null) {
                this.map.put(opt, values[0]);
            } else {
                this.map.remove((Object)opt);
            }
        } else {
            this.addDefinitions(values);
        }
        return this;
    }

    public DriverOptions addDefinitions(String ... defs) {
        if (defs == null) {
            return this;
        }
        for (String def : defs) {
            String capValue;
            String capName;
            String[] pair;
            if (def.contains("+=")) {
                pair = def.split("\\+=", 2);
                capName = pair[0];
                capValue = pair[1];
                Object prevCapValue = this.caps.getCapability(capName);
                if (prevCapValue == null) {
                    this.caps.setCapability(capName, (Object)new String[]{capValue});
                    continue;
                }
                if (prevCapValue instanceof String) {
                    this.caps.setCapability(capName, (Object)new String[]{(String)prevCapValue, capValue});
                    continue;
                }
                if (prevCapValue instanceof String[]) {
                    this.caps.setCapability(capName, (Object)ArrayUtils.add((Object[])((String[])prevCapValue), (Object)capValue));
                    continue;
                }
                throw new IllegalArgumentException("The capability " + capName + " is not string.");
            }
            if (def.contains("=")) {
                pair = def.split("=", 2);
                capName = pair[0];
                capValue = pair[1];
                this.caps.setCapability(capName, capValue);
                continue;
            }
            throw new IllegalArgumentException("The definition format need to be KEY=VALUE or KEY+=VALUE: " + def);
        }
        return this;
    }

    public String toString() {
        Map capsMap;
        StringBuilder result = new StringBuilder("[");
        String sep = "";
        if (!this.map.isEmpty()) {
            for (DriverOption driverOption : DriverOption.values()) {
                if (driverOption == DriverOption.DEFINE || !this.map.containsKey((Object)driverOption)) continue;
                result.append(driverOption.name()).append('=').append(this.map.get((Object)driverOption)).append('|');
            }
            result.deleteCharAt(result.length() - 1);
            sep = "|";
        }
        if (!(capsMap = this.caps.asMap()).isEmpty()) {
            result.append(sep).append("DEFINE=[\n");
            ArrayList capsList = new ArrayList(capsMap.entrySet());
            Collections.sort(capsList, new Comparator<Map.Entry<String, Object>>(){

                @Override
                public int compare(Map.Entry<String, Object> e1, Map.Entry<String, Object> e2) {
                    return e1.getKey().compareTo(e2.getKey());
                }
            });
            for (Map.Entry entry : capsList) {
                Object value = entry.getValue();
                if (value instanceof Object[]) {
                    value = StringUtils.join((Object[])((Object[])value), (String)", ");
                }
                result.append("  ").append((String)entry.getKey()).append('=').append(value).append("\n");
            }
            result.append(']');
        }
        result.append(']');
        return result.toString();
    }

    public DesiredCapabilities getCapabilities() {
        return this.caps;
    }

    public static enum DriverOption {
        PROFILE,
        PROFILE_DIR,
        PROXY,
        PROXY_USER,
        PROXY_PASSWORD,
        NO_PROXY,
        CHROMEDRIVER,
        IEDRIVER,
        PHANTOMJS,
        REMOTE_PLATFORM,
        REMOTE_BROWSER,
        REMOTE_VERSION,
        REMOTE_URL,
        WIDTH,
        HEIGHT,
        DEFINE;

    }
}

