/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.io.File;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeDriverFactory
extends WebDriverFactory {
    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        File driver;
        if (driverOptions.has(DriverOptions.DriverOption.CHROMEDRIVER)) {
            driver = new File(driverOptions.get(DriverOptions.DriverOption.CHROMEDRIVER));
            if (!driver.canExecute()) {
                throw new IllegalArgumentException("Missing ChromeDriver: " + driver);
            }
        } else {
            driver = PathUtils.searchExecutableFile("chromedriver");
            if (driver == null) {
                throw new IllegalStateException("Missing ChromeDriver in PATH");
            }
        }
        ChromeDriverService service = new ChromeDriverService.Builder().usingDriverExecutable(driver).usingAnyFreePort().withEnvironment(this.getEnvironmentVariables()).build();
        DesiredCapabilities caps = DesiredCapabilities.chrome();
        ChromeOptions options = new ChromeOptions();
        if (driverOptions.has(DriverOptions.DriverOption.PROXY)) {
            options.addArguments(new String[]{"--proxy-server=http://" + driverOptions.get(DriverOptions.DriverOption.PROXY)});
        }
        caps.setCapability("chromeOptions", (Object)options);
        caps.merge((Capabilities)driverOptions.getCapabilities());
        return new ChromeDriver(service, (Capabilities)caps);
    }
}

