/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.util.concurrent.TimeUnit;
import org.openqa.selenium.support.ui.Duration;

public class StopWatch {
    private long startTimeOfUTC;
    private long endTimeOfUTC;
    private long startTime;
    private long endTime;

    public void start() {
        this.start(System.nanoTime(), System.currentTimeMillis());
    }

    public void start(long nanoTime, long currentTimeMillis) {
        this.startTime = this.endTime = nanoTime;
        this.startTimeOfUTC = this.endTimeOfUTC = currentTimeMillis;
    }

    public void end() {
        this.end(System.nanoTime(), System.currentTimeMillis());
    }

    public void end(long nanoTime, long currentTimeMillis) {
        this.endTime = nanoTime;
        this.endTimeOfUTC = currentTimeMillis;
    }

    public long getStartTimeOfUTC() {
        return this.startTimeOfUTC;
    }

    public long getEndTimeOfUTC() {
        return this.endTimeOfUTC;
    }

    public long getDurationNanoSec() {
        return this.endTime - this.startTime;
    }

    public String getDurationString() {
        StringBuilder ds = new StringBuilder();
        Duration d = new Duration(this.endTime - this.startTime, TimeUnit.NANOSECONDS);
        long h = d.in(TimeUnit.HOURS);
        if (h > 0L) {
            ds.append(h).append("hour");
        }
        long m = d.in(TimeUnit.MINUTES) % 60L;
        if (ds.length() > 0) {
            ds.append('/').append(m).append("min");
        } else if (m > 0L) {
            ds.append(m).append("min");
        }
        long s = d.in(TimeUnit.SECONDS) % 60L;
        double ms = (double)(d.in(TimeUnit.MILLISECONDS) % 1000L) / 1000.0;
        if (ds.length() > 0) {
            ds.append('/');
        }
        ds.append(String.format("%.3fsec", (double)s + ms));
        return ds.toString();
    }
}

