/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.time.FastDateFormat;

public class LogRecorder {
    private static final FastDateFormat DATE_TIME_FORMAT = FastDateFormat.getInstance((String)"[yyyy-MM-dd HH:mm:ss.SSS] ");
    private final PrintStream ps;
    private final List<LogMessage> messages = new ArrayList<LogMessage>();
    private final List<LogMessage> errorMessages = new ArrayList<LogMessage>();

    public LogRecorder(PrintStream ps) {
        this.ps = ps;
    }

    public long now() {
        return System.currentTimeMillis();
    }

    public void info(String message) {
        LogMessage lmsg = new LogMessage(this.now(), Level.INFO, message);
        this.messages.add(lmsg);
        this.ps.println(lmsg);
    }

    public void error(String message) {
        LogMessage lmsg = new LogMessage(this.now(), Level.ERROR, message);
        this.messages.add(lmsg);
        this.errorMessages.add(lmsg);
        this.ps.println(lmsg);
    }

    public List<LogMessage> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public List<LogMessage> getErrorMessages() {
        return Collections.unmodifiableList(this.errorMessages);
    }

    public static class LogMessage {
        public final long date = System.currentTimeMillis();
        public final Level level;
        public final String message;

        private LogMessage(long date, Level level, String message) {
            this.level = level;
            this.message = message;
        }

        public String toString() {
            return DATE_TIME_FORMAT.format(this.date) + "[" + (Object)((Object)this.level) + "] " + this.message;
        }
    }

    public static enum Level {
        INFO,
        ERROR;

    }
}

