/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.locator;

import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.ElementFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.locator.AdditionalHandler;
import jp.vmi.selenium.selenese.locator.CSSHandler;
import jp.vmi.selenium.selenese.locator.DomHandler;
import jp.vmi.selenium.selenese.locator.IdHandler;
import jp.vmi.selenium.selenese.locator.IdentifierHandler;
import jp.vmi.selenium.selenese.locator.LinkHandler;
import jp.vmi.selenium.selenese.locator.LocatorHandler;
import jp.vmi.selenium.selenese.locator.NameHandler;
import jp.vmi.selenium.selenese.locator.OptionIdHandler;
import jp.vmi.selenium.selenese.locator.OptionIndexHandler;
import jp.vmi.selenium.selenese.locator.OptionLabelHandler;
import jp.vmi.selenium.selenese.locator.OptionLocatorHandler;
import jp.vmi.selenium.selenese.locator.OptionValueHandler;
import jp.vmi.selenium.selenese.locator.XPathHandler;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebDriverElementFinder
extends ElementFinder {
    public static final char OPTION_LOCATOR_SEPARATOR = '\u0000';
    private static final Pattern LOCATORS_RE = Pattern.compile("(\\w+)=(.*)|(document\\..*)|(//.*)");
    private static final int LOCATOR_TYPE = 1;
    private static final int LOCATOR_ARG = 2;
    private static final int DOM_LOCATOR = 3;
    private static final int XPATH_LOCATOR = 4;
    private final Map<String, LocatorHandler> handlerMap = new HashMap<String, LocatorHandler>();
    private final Map<String, OptionLocatorHandler> optionHandlerMap = new HashMap<String, OptionLocatorHandler>();

    public static String convertToOptionLocatorWithParent(String parentLocator, String optionLocator) {
        return parentLocator + '\u0000' + optionLocator;
    }

    public WebDriverElementFinder() {
        this.registerHandler(new IdentifierHandler());
        this.registerHandler(new IdHandler());
        this.registerHandler(new NameHandler());
        this.registerHandler(new DomHandler());
        this.registerHandler(new XPathHandler());
        this.registerHandler(new LinkHandler());
        this.registerHandler(new CSSHandler());
        this.registerOptionHandler(new OptionLabelHandler());
        this.registerOptionHandler(new OptionIdHandler());
        this.registerOptionHandler(new OptionIndexHandler());
        this.registerOptionHandler(new OptionValueHandler());
    }

    public WebDriverElementFinder registerHandler(LocatorHandler handler) {
        this.handlerMap.put(handler.locatorType(), handler);
        return this;
    }

    public WebDriverElementFinder registerOptionHandler(OptionLocatorHandler handler) {
        this.optionHandlerMap.put(handler.optionLocatorType(), handler);
        return this;
    }

    public void add(String strategyName, String implementation) {
        this.registerHandler(new AdditionalHandler(strategyName, implementation));
    }

    public WebElement superFindElement(WebDriver driver, String locator) {
        return super.findElement(driver, locator);
    }

    private boolean hasFrames(WebDriver driver) {
        if (driver instanceof JavascriptExecutor) {
            return (Boolean)((JavascriptExecutor)driver).executeScript("return window.frames.length > 0", new Object[0]);
        }
        return false;
    }

    private List<WebElement> findElementsByLocator(LocatorHandler handler, WebDriver driver, String arg, String locator) {
        WebDriver.TargetLocator switchTo = driver.switchTo();
        switchTo.defaultContent();
        List<WebElement> result = handler.handle(driver, arg);
        if (!result.isEmpty()) {
            return result;
        }
        if (this.hasFrames(driver)) {
            List iframes = driver.findElements(By.tagName((String)"iframe"));
            for (WebElement iframe : iframes) {
                switchTo.frame(iframe);
                result = handler.handle(driver, arg);
                if (result.isEmpty()) continue;
                return result;
            }
        }
        throw new SeleniumException("Element " + locator + " not found");
    }

    private List<WebElement> filterElementsByOptionLocator(List<WebElement> elements, String option) {
        String arg;
        String type;
        if (option == null) {
            return elements;
        }
        String[] pair = option.split("=", 2);
        if (pair.length == 1) {
            type = "label";
            arg = option;
        } else {
            type = pair[0];
            arg = pair[1];
        }
        OptionLocatorHandler handler = this.optionHandlerMap.get(type);
        if (handler == null) {
            throw new UnsupportedOperationException("Unknown option locator type: " + option);
        }
        ArrayList<WebElement> result = new ArrayList<WebElement>();
        for (WebElement element : elements) {
            result.addAll(handler.handle(element, arg));
        }
        return result;
    }

    private String formatLocator(String locator, String option) {
        return option == null ? locator : locator + " (" + option + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<WebElement> findElements(WebDriver driver, String locator) {
        String arg;
        String type;
        String option;
        int optIndex = locator.indexOf(0);
        if (optIndex >= 0) {
            option = locator.substring(optIndex + 1);
            locator = locator.substring(0, optIndex);
        } else {
            option = null;
        }
        Matcher matcher = LOCATORS_RE.matcher(locator);
        if (matcher.matches()) {
            type = matcher.group(1);
            arg = matcher.group(2);
            if (StringUtils.isNotEmpty((CharSequence)type)) {
                type = type.toLowerCase();
            } else if (StringUtils.isNotEmpty((CharSequence)matcher.group(3))) {
                type = "dom";
                arg = locator;
            } else {
                if (!StringUtils.isNotEmpty((CharSequence)matcher.group(4))) throw new UnsupportedOperationException("Unknown locator type: " + this.formatLocator(locator, option));
                type = "xpath";
                arg = locator;
            }
        } else {
            type = "identifier";
            arg = locator;
        }
        LocatorHandler handler = this.handlerMap.get(type);
        if (handler != null) return this.filterElementsByOptionLocator(this.findElementsByLocator(handler, driver, arg, locator), option);
        throw new UnsupportedOperationException("Unknown locator type: " + this.formatLocator(locator, option));
    }

    public WebElement findElement(WebDriver driver, String locator) {
        return this.findElements(driver, locator).get(0);
    }
}

