/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.inject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jp.vmi.junit.result.JUnitResultHolder;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.LogIndentLevelHolder;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.utils.LogRecorder;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLogInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CommandLogInterceptor.class);
    private static final Comparator<Cookie> cookieComparator = new Comparator<Cookie>(){

        @Override
        public int compare(Cookie c1, Cookie c2) {
            return c1.getName().compareTo(c2.getName());
        }
    };
    private static final FastDateFormat expiryFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private List<String> prevMessages = new ArrayList<String>();
    private static final int CONTEXT = 0;
    private static final int COMMAND = 1;

    private void cookieToMessage(List<String> messages, Set<Cookie> cookies) {
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>(cookies);
        Collections.sort(cookieList, cookieComparator);
        for (Cookie cookie : cookieList) {
            Date expiry = cookie.getExpiry();
            String expiryString = expiry != null ? expiryFormat.format(expiry) : "*";
            messages.add(String.format("- Cookie: %s=[%s] (domain=%s, path=%s, expire=%s)", cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), expiryString));
        }
    }

    private void log(String indent, String cmdStr, Result result, TestCase testCase, Context context) {
        LogRecorder clr = testCase.getLogRecorder();
        List<String> messages = this.getPageInformation(testCase, context);
        if (ListUtils.isEqualList(messages, this.prevMessages)) {
            if (result.isFailed()) {
                String resStr = cmdStr + " => " + result;
                log.error(indent + resStr);
                clr.error(indent + resStr);
            } else {
                String resStr = "- " + result;
                log.info(indent + resStr);
                clr.info(indent + resStr);
            }
        } else {
            Iterator<String> iter = messages.iterator();
            String message = iter.next();
            if (result.isFailed()) {
                String resStr = cmdStr + " => " + result + " " + message;
                log.error(indent + resStr);
                clr.error(indent + resStr);
                while (iter.hasNext()) {
                    message = iter.next();
                    log.error(indent + message);
                    clr.error(indent + message);
                }
            } else {
                String resStr = "- " + result + " " + message;
                log.info(indent + resStr);
                clr.info(indent + resStr);
                while (iter.hasNext()) {
                    message = iter.next();
                    log.info(indent + message);
                    clr.info(indent + message);
                }
            }
            this.prevMessages = messages;
        }
    }

    private String getMessage(Exception e) {
        String msg = e.getMessage();
        if (msg != null) {
            return msg.replaceFirst("(?s)\r?\nBuild info:.*", "");
        }
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add(e.toString());
        String pkgName = this.getClass().getPackage().getName() + ".";
        for (StackTraceElement ste : e.getStackTrace()) {
            if (ste.getClassName().startsWith(pkgName)) break;
            msgs.add(ste.toString().trim());
        }
        return StringUtils.join(msgs, (String)" / at ");
    }

    private List<String> getPageInformation(TestCase testCase, Context context) {
        ArrayList<String> messages = new ArrayList<String>();
        WebDriver driver = context.getWrappedDriver();
        try {
            String handle = driver.getWindowHandle();
            if (StringUtils.isEmpty((CharSequence)handle)) {
                throw new NotFoundException();
            }
            driver.switchTo().window(handle);
            String url = driver.getCurrentUrl();
            String title = driver.getTitle();
            Set cookies = driver.manage().getCookies();
            messages.add(String.format("URL: [%s] / Title: [%s]", url, title));
            this.cookieToMessage(messages, cookies);
        }
        catch (NotFoundException e) {
            messages.add("No focused window/frame.");
        }
        catch (UnhandledAlertException e) {
            messages.add(String.format("No page information: [%s]", this.getMessage((Exception)((Object)e))));
        }
        catch (Exception e) {
            messages.add(String.format("Failed to get page information: [%s]", this.getMessage(e)));
        }
        return messages;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        LogIndentLevelHolder holder = (LogIndentLevelHolder)invocation.getThis();
        Object[] args = invocation.getArguments();
        Context context = (Context)args[0];
        ICommand command = (ICommand)args[1];
        TestCase testCase = context.getCurrentTestCase();
        LogRecorder clr = testCase.getLogRecorder();
        String indent = StringUtils.repeat((String)"  ", (int)holder.getLogIndentLevel());
        String cmdStr = command.toString();
        log.info(indent + cmdStr);
        clr.info(indent + cmdStr);
        try {
            Result result = (Result)invocation.proceed();
            this.log(indent, cmdStr, result, testCase, context);
            return result;
        }
        catch (Exception e) {
            String msg = cmdStr + " => " + e.getMessage();
            log.error(indent + msg);
            clr.error(indent + msg);
            if (context instanceof JUnitResultHolder) {
                ((JUnitResultHolder)((Object)context)).getJUnitResult().setError(testCase, e.getMessage(), e.toString());
            }
            throw e;
        }
    }
}

