/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import com.thoughtworks.selenium.SeleniumException;
import java.util.ListIterator;
import jp.vmi.selenium.selenese.command.CommandList;
import jp.vmi.selenium.selenese.command.ICommand;

public class CommandListIterator
implements ListIterator<ICommand> {
    private final CommandList commandList;
    private ListIterator<ICommand> iterator;

    private String unsupportedMessage(String methodName) {
        return this.getClass().getSimpleName() + "#" + methodName + " is not supported.";
    }

    CommandListIterator(CommandList commandList) {
        this.commandList = commandList;
        this.iterator = commandList.originalListIterator(0);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ICommand next() {
        return this.iterator.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.iterator.hasPrevious();
    }

    @Override
    public ICommand previous() {
        return this.iterator.previous();
    }

    @Override
    public int nextIndex() {
        return this.iterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.iterator.previousIndex();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.unsupportedMessage("remove()"));
    }

    @Override
    public void set(ICommand e) {
        throw new UnsupportedOperationException(this.unsupportedMessage("set(ICommand)"));
    }

    @Override
    public void add(ICommand e) {
        throw new UnsupportedOperationException(this.unsupportedMessage("add(ICommand)"));
    }

    public void jumpTo(Object key) {
        int index;
        if (key == null) {
            index = this.commandList.size();
        } else {
            index = this.commandList.indexOf(key);
            if (index == -1) {
                throw new SeleniumException("Cannot jump to " + key);
            }
        }
        this.iterator = this.commandList.originalListIterator(index);
    }

    public void jumpToNextOf(Object key) {
        int index;
        if (key == null) {
            index = this.commandList.size();
        } else {
            index = this.commandList.indexOf(key);
            if (index == -1) {
                throw new SeleniumException("Cannot jump to next of " + key);
            }
            ++index;
        }
        this.iterator = this.commandList.originalListIterator(index);
    }

    public int getLogIndentLevel() {
        return this.commandList.getLogIndentLevel();
    }
}

