/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.CommandListIterator;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.ILabel;
import jp.vmi.selenium.selenese.command.LogIndentLevelHolder;
import jp.vmi.selenium.selenese.inject.DoCommand;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;

public class CommandList
extends ArrayList<ICommand>
implements LogIndentLevelHolder {
    private static final long serialVersionUID = 1L;
    private final Map<Object, Integer> indexCache = new HashMap<Object, Integer>();
    private int logIndentLevel = 0;

    @Override
    public int getLogIndentLevel() {
        return this.logIndentLevel;
    }

    @Override
    public void setLogIndentLevel(int logIndentLevel) {
        this.logIndentLevel = logIndentLevel;
    }

    @Override
    public boolean add(ICommand command) {
        if (command instanceof ILabel) {
            this.indexCache.put(((ILabel)((Object)command)).getLabel(), this.size());
        }
        return super.add(command);
    }

    @Override
    public int indexOf(Object key) {
        Integer index = this.indexCache.get(key);
        if (index == null) {
            index = super.indexOf(key);
            if (index == null) {
                return -1;
            }
            this.indexCache.put(key, index);
        }
        return index;
    }

    public ListIterator<ICommand> originalListIterator(int index) {
        return super.listIterator(index);
    }

    public CommandListIterator listIterator(int index) {
        return new CommandListIterator(this);
    }

    public CommandListIterator listIterator() {
        return this.listIterator(0);
    }

    public CommandListIterator iterator() {
        return this.listIterator();
    }

    @DoCommand
    protected Result doCommand(Context context, ICommand command, String ... curArgs) {
        try {
            return command.execute(context, curArgs);
        }
        catch (Exception e) {
            return new Error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Context context) {
        Result result = Success.SUCCESS;
        CommandListIterator commandListIterator = this.listIterator();
        context.pushCommandListIterator(commandListIterator);
        try {
            while (commandListIterator.hasNext()) {
                String[] curArgs;
                ICommand command = commandListIterator.next();
                if ((result = result.update(this.doCommand(context, command, curArgs = context.getVarsMap().replaceVarsForArray(command.getArguments())))).isAborted()) {
                    break;
                }
                context.waitSpeed();
            }
        }
        finally {
            context.popCommandListIterator();
        }
        return result;
    }
}

