/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.vmi.selenium.selenese.Runner;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.utils.LoggerUtils;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final int HELP_WIDTH = 78;
    private static final String PROG_TITLE = "Selenese Runner";
    private static final String HEADER = "Selenese script interpreter implemented by Java.";
    private static final String FOOTER = "*note: If you want to use basic and/or proxy authentication on Firefox, then create new profile, install AutoAuth plugin, configure all settings, access test site with the profile, and specify the profile by --profile option.";
    private static final String DEFAULT_TIMEOUT_MILLISEC = "30000";
    private final SROptions options = new SROptions();

    public Main() {
        OptionBuilder.withLongOpt((String)"driver");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"driver");
        OptionBuilder.withDescription((String)"firefox (default) | chrome | ie | safari | htmlunit | phantomjs | remote | appium | FQCN-of-WebDriverFactory");
        this.options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"profile");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.withDescription((String)"profile name (Firefox only)");
        this.options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"profile-dir");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.withDescription((String)"profile directory (Firefox only)");
        this.options.addOption(OptionBuilder.create((char)'P'));
        OptionBuilder.withLongOpt((String)"proxy");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"proxy");
        OptionBuilder.withDescription((String)"proxy host and port (HOST:PORT) (excepting IE)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"proxy-user");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"user");
        OptionBuilder.withDescription((String)"proxy username (HtmlUnit only *)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"proxy-password");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.withDescription((String)"proxy password (HtmlUnit only *)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"no-proxy");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"no-proxy");
        OptionBuilder.withDescription((String)"no-proxy hosts");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"remote-url");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.withDescription((String)"Remote test runner URL (Remote only)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"remote-platform");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"platform");
        OptionBuilder.withDescription((String)"Desired remote platform (Remote only)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"remote-browser");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"browser");
        OptionBuilder.withDescription((String)"Desired remote browser (Remote only)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"remote-version");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"browser-version");
        OptionBuilder.withDescription((String)"Desired remote browser version (Remote only)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"highlight");
        OptionBuilder.withDescription((String)"highlight locator always.");
        this.options.addOption(OptionBuilder.create((char)'H'));
        OptionBuilder.withLongOpt((String)"screenshot-dir");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.withDescription((String)"override captureEntirePageScreenshot directory.");
        this.options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"screenshot-all");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.withDescription((String)"take screenshot at all commands to specified directory.");
        this.options.addOption(OptionBuilder.create((char)'S'));
        OptionBuilder.withLongOpt((String)"screenshot-on-fail");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.withDescription((String)"take screenshot on fail commands to specified directory.");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"ignore-screenshot-command");
        OptionBuilder.withDescription((String)"ignore captureEntirePageScreenshot command.");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"baseurl");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"baseURL");
        OptionBuilder.withDescription((String)"override base URL set in selenese.");
        this.options.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"chromedriver");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"path to 'chromedriver' binary. (implies '--driver chrome')");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"iedriver");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"path to 'IEDriverServer' binary. (implies '--driver ie')");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"phantomjs");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"path to 'phantomjs' binary. (implies '--driver phantomjs')");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"xml-result");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.withDescription((String)"output XML JUnit results to specified directory.");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"html-result");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"dir");
        OptionBuilder.withDescription((String)"output HTML results to specified directory.");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"timeout");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"timeout");
        OptionBuilder.withDescription((String)"set timeout (ms) for waiting. (default: 30000 ms)");
        this.options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"set-speed");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"speed");
        OptionBuilder.withDescription((String)"same as executing setSpeed(ms) command first.");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"height");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"height");
        OptionBuilder.withDescription((String)"browser height (only phantomjs)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"width");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"width");
        OptionBuilder.withDescription((String)"browser width (only phantomjs)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"key=value or key+=value");
        OptionBuilder.withDescription((String)"define parameters for capabilities. (multiple)");
        this.options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withLongOpt((String)"rollup");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withDescription((String)"define rollup rule by JavaScript. (multiple)");
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"show this message.");
        this.options.addOption(OptionBuilder.create((char)'h'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/jp.vmi/selenese-runner-java/pom.properties");
        if (is != null) {
            try {
                Properties prop = new Properties();
                prop.load(is);
                String string = prop.getProperty("version");
                return string;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return "(missing version information)";
    }

    private int getHelpWidth() {
        String columns = System.getenv("COLUMNS");
        if (columns != null && columns.matches("\\d+")) {
            try {
                return Integer.parseInt(columns) - 2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 78;
    }

    private void help(String ... msgs) {
        if (msgs.length > 0) {
            for (String msg : msgs) {
                System.out.println(msg);
            }
            System.out.println();
        }
        int helpWidth = this.getHelpWidth();
        String progName = System.getenv("PROG_NAME");
        if (StringUtils.isBlank((CharSequence)progName)) {
            progName = "java -jar selenese-runner.jar";
        }
        HelpFormatter fmt = new HelpFormatter();
        fmt.setOptionComparator(this.options.getOptionComparator());
        PrintWriter pw = new PrintWriter(System.out);
        pw.format("Selenese Runner %s%n%nSelenese script interpreter implemented by Java.%n%n", this.getVersion());
        fmt.setSyntaxPrefix("Usage: ");
        fmt.printHelp(pw, helpWidth, progName + " <option> ... <test-case|test-suite> ...\n", null, (Options)this.options, 1, 3, null);
        pw.println();
        fmt.printWrapped(pw, helpWidth, FOOTER);
        pw.flush();
        this.exit(1);
    }

    public CommandLine parseCommandLine(String ... args) throws IllegalArgumentException {
        CommandLine cli = null;
        try {
            cli = new PosixParser().parse((Options)this.options, args);
            log.debug("Specified options:");
            for (Option opt : cli.getOptions()) {
                log.debug("[{}]=[{}]", (Object)opt.getLongOpt(), (Object)opt.getValue());
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return cli;
    }

    public void run(String[] args) {
        int exitCode = 1;
        try {
            CommandLine cli = this.parseCommandLine(args);
            String[] filenames = cli.getArgs();
            if (filenames.length == 0) {
                this.help(new String[0]);
            }
            log.info("Start: Selenese Runner {}", (Object)this.getVersion());
            String driverName = cli.getOptionValue("driver");
            DriverOptions driverOptions = new DriverOptions(cli);
            if (driverName == null) {
                if (driverOptions.has(DriverOptions.DriverOption.CHROMEDRIVER)) {
                    driverName = "chrome";
                } else if (driverOptions.has(DriverOptions.DriverOption.IEDRIVER)) {
                    driverName = "ie";
                } else if (driverOptions.has(DriverOptions.DriverOption.PHANTOMJS)) {
                    driverName = "phantomjs";
                }
            }
            WebDriverManager manager = WebDriverManager.getInstance();
            manager.setWebDriverFactory(driverName);
            manager.setDriverOptions(driverOptions);
            Runner runner = new Runner();
            runner.setDriver(manager.get());
            runner.setHighlight(cli.hasOption("highlight"));
            runner.setScreenshotDir(cli.getOptionValue("screenshot-dir"));
            runner.setScreenshotAllDir(cli.getOptionValue("screenshot-all"));
            runner.setScreenshotOnFailDir(cli.getOptionValue("screenshot-on-fail"));
            runner.setOverridingBaseURL(cli.getOptionValue("baseurl"));
            runner.setIgnoredScreenshotCommand(cli.hasOption("ignore-screenshot-command"));
            if (cli.hasOption("rollup")) {
                String[] rollups;
                for (String rollup : rollups = cli.getOptionValues("rollup")) {
                    runner.getRollupRules().load(rollup);
                }
            }
            runner.setJUnitResultDir(cli.getOptionValue("xml-result"));
            runner.setHtmlResultDir(cli.getOptionValue("html-result"));
            int timeout = NumberUtils.toInt((String)cli.getOptionValue("timeout", DEFAULT_TIMEOUT_MILLISEC));
            if (timeout <= 0) {
                throw new IllegalArgumentException("Invalid timeout value. (" + cli.getOptionValue("timeout") + ")");
            }
            runner.setTimeout(timeout);
            int speed = NumberUtils.toInt((String)cli.getOptionValue("set-speed", "0"));
            if (speed < 0) {
                throw new IllegalArgumentException("Invalid speed value. (" + cli.getOptionValue("set-speed") + ")");
            }
            runner.setInitialSpeed(speed);
            runner.setPrintStream(System.out);
            Result totalResult = runner.run(filenames);
            runner.finish();
            exitCode = totalResult.getLevel().exitCode;
        }
        catch (IllegalArgumentException e) {
            this.help("Error: " + e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.exit(exitCode);
    }

    protected void exit(int exitCode) {
        System.exit(exitCode);
    }

    public static void main(String[] args) {
        LoggerUtils.initLogger();
        new Main().run(args);
    }

    private static class SROptions
    extends Options {
        private static final long serialVersionUID = 1L;
        private int i = 0;
        public final Map<Option, Integer> optionOrder = new HashMap<Option, Integer>();

        private SROptions() {
        }

        public Options addOption(Option opt) {
            this.optionOrder.put(opt, ++this.i);
            return super.addOption(opt);
        }

        public Comparator<Option> getOptionComparator() {
            return new Comparator<Option>(){

                @Override
                public int compare(Option o1, Option o2) {
                    return SROptions.this.optionOrder.get(o1) - SROptions.this.optionOrder.get(o2);
                }
            };
        }
    }
}

