/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import jp.vmi.junit.result.ITestTarget;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.utils.StopWatch;
import org.apache.commons.io.FilenameUtils;

public abstract class ErrorSource
implements Selenese,
ITestTarget {
    private String filename;
    private InvalidSeleneseException e;
    private final StopWatch stopWatch = new StopWatch();

    public ErrorSource initialize(String filename, InvalidSeleneseException e) {
        this.filename = filename;
        this.e = e;
        return this;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public String getName() {
        return FilenameUtils.getBaseName((String)this.filename);
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    @Override
    public Result execute(Selenese parent, Context context) throws InvalidSeleneseException {
        throw this.e;
    }

    public Result getResult() {
        return new Error(this.e);
    }

    public String toString() {
        String name = this.getClass().getSimpleName().replaceFirst("\\$\\$.*$", "");
        return String.format("%s[%s] %s", name, this.filename, this.e.getMessage());
    }
}

