/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.rollup;

import com.thoughtworks.selenium.SeleniumException;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jp.vmi.script.JSArray;
import jp.vmi.selenium.rollup.IRollupRule;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.CommandList;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.inject.Binder;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class RollupRule
implements IRollupRule {
    private final ScriptEngine engine;
    private final Map<?, ?> rule;

    RollupRule(ScriptEngine engine, Map<?, ?> rule) {
        this.engine = engine;
        this.rule = rule;
    }

    @Override
    public String getName() {
        return (String)this.rule.get("name");
    }

    @Override
    public CommandList getExpandedCommands(Context context, Map<String, String> rollupArgs) {
        JSArray commands;
        if (this.rule.containsKey("expandedCommands")) {
            commands = JSArray.wrap(this.rule.get("expandedCommands"));
        } else {
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("rule", (Object)this.rule);
            String args = new JSONObject(rollupArgs).toString();
            try {
                commands = JSArray.wrap(this.engine.eval("rule.getExpandedCommands(" + args + ")", (Bindings)bindings));
            }
            catch (ScriptException e) {
                throw new SeleniumException((Exception)e);
            }
        }
        ICommandFactory factory = context.getCommandFactory();
        CommandList commandList = Binder.newCommandList();
        int index = 0;
        for (Map c : commands) {
            String name = (String)c.get("command");
            String target = StringUtils.defaultString((String)((String)c.get("target")));
            String value = StringUtils.defaultString((String)((String)c.get("value")));
            ICommand command = factory.newCommand(++index, name, target, value);
            commandList.add(command);
        }
        return commandList;
    }
}

