/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.rollup;

import com.thoughtworks.selenium.SeleniumException;
import java.util.Map;
import jp.vmi.script.JSArray;
import jp.vmi.selenium.rollup.RollupRules;
import org.apache.commons.collections.Closure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollupManager {
    private static final Logger log = LoggerFactory.getLogger(RollupManager.class);
    private static RollupRules currentRollupRules = null;

    public static synchronized void rollupRulesContext(RollupRules rollupRules, Closure closure) {
        currentRollupRules = rollupRules;
        try {
            closure.execute(null);
        }
        finally {
            currentRollupRules = null;
        }
    }

    public void addRollupRule(Map<?, ?> rule) {
        currentRollupRules.addRule(rule);
        log.info("Added rollup rule: {}", rule.get("name"));
        log.info("- Description: {}", rule.get("description"));
        JSArray<Map> args = JSArray.wrap(rule.get("args"));
        if (args != null && args.size() > 0) {
            log.info("- Arguments:");
            for (Map arg : args) {
                log.info("  + {}: {}", arg.get("name"), arg.get("description"));
            }
        }
        if (rule.containsKey("expandedCommands")) {
            log.info("- Expanded commands: array");
        } else if (rule.containsKey("getExpandedCommands")) {
            log.info("- Expanded commands: function");
        } else {
            throw new SeleniumException("Missing expandedCommands nor getExpandedCommands in rollup rule definition.");
        }
    }
}

