/*
 * Decompiled with CFR 0.152.
 */
package it.swim.recon;

import it.swim.recon.Extant;
import it.swim.recon.Field;
import it.swim.recon.Recon;
import it.swim.util.Show;

public final class Slot
extends Field
implements Comparable<Slot> {
    private final Object key;
    private Object value;

    public Slot(Object key, Object value) {
        this.key = key;
        this.value = value;
    }

    public Slot(Object key) {
        this.key = key;
        this.value = Recon.EXTANT;
    }

    @Override
    public boolean isSlot() {
        return true;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object setValue(Object value) {
        Object oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    @Override
    public int compareTo(Slot that) {
        int order = Recon.compareObject(this.getKey(), that.getKey());
        if (order == 0) {
            order = Recon.compareObject(this.getValue(), that.getValue());
        }
        return order;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Slot) {
            Slot that = (Slot)other;
            return (this.key == null ? that.key == null : this.key.equals(that.key)) && (this.value == null ? that.value == null : this.value.equals(that.value));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Slot");
        builder.append('(');
        Show.append((StringBuilder)builder, (Object)this.key);
        if (!(this.value instanceof Extant)) {
            builder.append(", ");
            Show.append((StringBuilder)builder, (Object)this.value);
        }
        builder.append(')');
        return builder.toString();
    }
}

