/*
 * Decompiled with CFR 0.152.
 */
package it.swim.recon;

import it.swim.recon.Attr;
import it.swim.recon.Field;
import it.swim.recon.Recon;
import it.swim.recon.ReconStringWriter;
import it.swim.recon.Slot;
import it.swim.util.Show;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;

public class Record
implements List<Object>,
RandomAccess,
Comparable<Record> {
    private Object[] array;
    private Field[] table;
    private int size;

    public static Record empty() {
        return new Record();
    }

    public static Record of(Object ... items) {
        return new Record(items);
    }

    private static int expand(int n) {
        n = Math.max(8, n) - 1;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    private Record(Object[] array) {
        this.array = array;
        this.table = null;
        this.size = array.length;
    }

    public Record(Collection<? extends Object> items) {
        this.array = new Object[Record.expand(items.size())];
        this.size = 0;
        java.util.Iterator<? extends Object> i$ = items.iterator();
        while (i$.hasNext()) {
            Object item;
            this.array[this.size] = item = i$.next();
            ++this.size;
        }
    }

    public Record(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(String.valueOf(initialCapacity));
        }
        this.array = new Object[initialCapacity];
        this.table = null;
        this.size = 0;
    }

    public Record() {
        this.array = null;
        this.table = null;
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object item) {
        Object[] array = this.array;
        int n = this.size;
        for (int index = 0; index < n; ++index) {
            Object x = array[index];
            if (!(item == null ? x == null : item.equals(x))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<? extends Object> items) {
        HashSet<? extends Object> looking = new HashSet<Object>(items);
        Object[] array = this.array;
        int n = this.size;
        for (int index = 0; index < n && !looking.isEmpty(); ++index) {
            looking.remove(array[index]);
        }
        return looking.isEmpty();
    }

    public boolean containsKey(Object key) {
        int start;
        if (this.size == 0) {
            return false;
        }
        this.hash();
        Field[] table = this.table;
        int n = table.length;
        if (n == 0) {
            return false;
        }
        int index = start = key != null ? key.hashCode() % n : 0;
        do {
            Field field;
            if ((field = table[index]) != null) {
                Object k = field.getKey();
                if (!(key == null ? k == null : key.equals(k))) continue;
                return true;
            }
            return false;
        } while ((index = (index + 1) % n) != start);
        return false;
    }

    public boolean containsValue(Object value) {
        if (this.size == 0) {
            return false;
        }
        this.hash();
        for (Field field : this.table) {
            if (field == null) continue;
            Object v = field.getValue();
            if (!(value == null ? v == null : value.equals(v))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.array[index];
    }

    public Object get(Object key) {
        return this.getValue(key);
    }

    public Object getValue(Object key) {
        int start;
        if (this.size == 0) {
            return null;
        }
        this.hash();
        Field[] table = this.table;
        int n = table.length;
        if (n == 0) {
            return null;
        }
        int index = start = key != null ? key.hashCode() % n : 0;
        do {
            Field field;
            if ((field = table[index]) != null) {
                Object k = field.getKey();
                if (!(key == null ? k == null : key.equals(k))) continue;
                return field.getValue();
            }
            return null;
        } while ((index = (index + 1) % n) != start);
        return null;
    }

    public Record getRecord(Object key) {
        Object value = this.getValue(key);
        if (value instanceof Record) {
            return (Record)value;
        }
        return null;
    }

    public String getString(Object key) {
        Object value = this.getValue(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public Number getNumber(Object key) {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return (Number)value;
        }
        return null;
    }

    public int getInt(Object key) {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new NoSuchElementException(key.toString());
    }

    public long getLong(Object key) {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new NoSuchElementException(key.toString());
    }

    public float getFloat(Object key) {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new NoSuchElementException(key.toString());
    }

    public double getDouble(Object key) {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new NoSuchElementException(key.toString());
    }

    public boolean getBoolean(Object key) {
        Object value = this.getValue(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String && value.equals("true")) {
            return true;
        }
        if (value instanceof String && value.equals("false")) {
            return false;
        }
        throw new NoSuchElementException(key.toString());
    }

    @Override
    public Object set(int index, Object item) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        Object oldItem = this.array[index];
        this.array[index] = item;
        if (oldItem instanceof Field || item instanceof Field) {
            this.table = null;
        }
        return oldItem;
    }

    public Object put(Object key, Object value) {
        Object[] array = this.array;
        int n = this.size;
        for (int index = 0; index < n; ++index) {
            Object item = array[index];
            if (!(item instanceof Field)) continue;
            Field field = (Field)item;
            Object k = field.getKey();
            if (!(key == null ? k == null : key.equals(k))) continue;
            return field.setValue(value);
        }
        Slot field = new Slot(key, value);
        this.add(field);
        if (this.table != null) {
            this.put(field);
        }
        return null;
    }

    public void putAll(Map<? extends Object, ? extends Object> items) {
        for (Map.Entry<? extends Object, ? extends Object> entry : items.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean add(Object item) {
        Object[] array = this.array;
        if (array == null || this.size + 1 > array.length) {
            array = new Object[Record.expand(this.size + 1)];
            if (this.array != null) {
                System.arraycopy(this.array, 0, array, 0, this.size);
            }
            this.array = array;
        }
        array[this.size] = item;
        if (item instanceof Field && this.table != null) {
            if (this.size + 1 <= this.table.length) {
                this.put((Field)item);
            } else {
                this.table = null;
            }
        }
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, Object item) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        if (index == this.size) {
            this.add(item);
        } else {
            Object[] array = this.array;
            if (this.size + 1 > array.length) {
                array = new Object[Record.expand(this.size + 1)];
                System.arraycopy(this.array, 0, array, 0, index);
            }
            System.arraycopy(this.array, index, array, index + 1, this.size - index);
            array[index] = item;
            this.array = array;
            if (item instanceof Field) {
                this.table = null;
            }
            ++this.size;
        }
    }

    @Override
    public boolean addAll(Collection<? extends Object> items) {
        int n = items.size();
        if (n == 0) {
            return false;
        }
        Object[] array = this.array;
        if ((array == null || this.size + n > array.length) && (array = new Object[Record.expand(this.size + n)]) != null) {
            System.arraycopy(this.array, 0, array, 0, this.size);
        }
        java.util.Iterator<? extends Object> i$ = items.iterator();
        while (i$.hasNext()) {
            Object item;
            array[this.size] = item = i$.next();
            if (item instanceof Field) {
                this.table = null;
            }
            ++this.size;
        }
        this.array = array;
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> items) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        if (index == this.size) {
            return this.addAll(items);
        }
        int n = items.size();
        if (n == 0) {
            return false;
        }
        Object[] array = this.array;
        if (this.size + n > array.length) {
            array = new Object[Record.expand(this.size + n)];
            System.arraycopy(this.array, 0, array, 0, index);
        }
        System.arraycopy(this.array, index, array, index + n, this.size - index);
        java.util.Iterator<? extends Object> i$ = items.iterator();
        while (i$.hasNext()) {
            Object item;
            array[index] = item = i$.next();
            if (item instanceof Field) {
                this.table = null;
            }
            ++index;
        }
        this.array = array;
        this.size += n;
        return true;
    }

    @Override
    public Object remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        Object[] array = this.array;
        Object oldItem = array[index];
        if (this.size == 1) {
            this.clear();
        } else {
            System.arraycopy(array, index + 1, array, index, this.size - index - 1);
            --this.size;
            array[this.size] = null;
        }
        if (oldItem instanceof Field) {
            this.table = null;
        }
        return oldItem;
    }

    @Override
    public boolean remove(Object item) {
        return this.removeItem(item);
    }

    public boolean removeItem(Object item) {
        int index = this.indexOf(item);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public boolean removeKey(Object key) {
        Object[] array = this.array;
        int n = this.size;
        for (int index = 0; index < n; ++index) {
            Object item = array[index];
            if (!(item instanceof Field)) continue;
            Field field = (Field)item;
            Object k = field.getKey();
            if (!(key == null ? k == null : key.equals(k))) continue;
            System.arraycopy(array, index + 1, array, index, this.size - index - 1);
            --this.size;
            array[this.size] = null;
            this.table = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        int i;
        Object[] array = this.array;
        int n = this.size;
        int j = 0;
        for (i = 0; i < n; ++i) {
            Object item = array[i];
            if (!items.contains(item)) {
                array[j] = array[i];
                ++j;
                continue;
            }
            if (!(item instanceof Field)) continue;
            this.table = null;
        }
        if (i > j) {
            while (i > j) {
                array[--i] = null;
            }
            this.size = i;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> items) {
        int i;
        Object[] array = this.array;
        int n = this.size;
        int j = 0;
        for (i = 0; i < n; ++i) {
            Object item = array[i];
            if (items.contains(item)) {
                array[j] = array[i];
                ++j;
                continue;
            }
            if (!(item instanceof Field)) continue;
            this.table = null;
        }
        if (i > j) {
            while (i > j) {
                array[--i] = null;
            }
            this.size = i;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.table = null;
        this.array = null;
    }

    @Override
    public int indexOf(Object item) {
        Object[] array = this.array;
        int n = this.size;
        for (int index = 0; index < n; ++index) {
            Object x = array[index];
            if (!(item == null ? x == null : item.equals(x))) continue;
            return index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object item) {
        Object[] array = this.array;
        for (int index = this.size - 1; index >= 0; --index) {
            Object x = array[index];
            if (!(item == null ? x == null : item.equals(x))) continue;
            return index;
        }
        return -1;
    }

    public Record attr(String key, Object value) {
        this.add(new Attr(key, value));
        return this;
    }

    public Record attr(String key) {
        this.add(new Attr(key));
        return this;
    }

    public Record slot(Object key, Object value) {
        this.add(new Slot(key, value));
        return this;
    }

    public Record slot(Object key) {
        this.add(new Slot(key));
        return this;
    }

    public Record item(Object item) {
        this.add(item);
        return this;
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException(fromIndex + ", " + toIndex);
        }
        return new SubList(fromIndex, toIndex);
    }

    public Set<Object> keySet() {
        return null;
    }

    public Collection<Object> values() {
        return null;
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return null;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        System.arraycopy(this.array, 0, array, 0, this.size);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.array, 0, array, 0, this.size);
        if (array.length > this.size) {
            array[this.size] = null;
        }
        return array;
    }

    @Override
    public java.util.Iterator<Object> iterator() {
        return new Iterator();
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new Iterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return new Iterator(index);
    }

    @Override
    public int compareTo(Record that) {
        Object[] xs = this.array;
        Object[] ys = that.array;
        int p = this.size;
        int q = that.size;
        int n = Math.min(p, q);
        int order = 0;
        for (int i = 0; i < n && order == 0; ++i) {
            order = Recon.compareObject(xs[i], ys[i]);
        }
        return order != 0 ? order : (p > q ? 1 : (p < q ? -1 : 0));
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof List)) {
            return false;
        }
        List that = (List)other;
        Object[] array = this.array;
        int n = this.size;
        if (n != that.size()) {
            return false;
        }
        for (int index = 0; index < n; ++index) {
            Object i1 = array[index];
            Object i2 = that.get(index);
            if (!(i1 == null ? i2 != null : !i1.equals(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        Object[] array = this.array;
        int n = this.size;
        int code = 1;
        for (int index = 0; index < n; ++index) {
            Object item = array[index];
            code = 31 * code + (item == null ? 0 : item.hashCode());
        }
        return code;
    }

    public String toString() {
        Object[] array = this.array;
        int n = this.size;
        StringBuilder builder = new StringBuilder("Record");
        builder.append('(');
        for (int index = 0; index < n; ++index) {
            if (index > 0) {
                builder.append(", ");
            }
            Show.append((StringBuilder)builder, (Object)array[index]);
        }
        builder.append(')');
        return builder.toString();
    }

    public String toRecon() {
        ReconStringWriter writer = new ReconStringWriter();
        writer.writeRecord(this);
        return writer.toString();
    }

    public String toReconBlock() {
        ReconStringWriter writer = new ReconStringWriter();
        writer.writeBlock(this);
        return writer.toString();
    }

    private void hash() {
        if (this.table != null) {
            return;
        }
        this.table = new Field[this.size];
        for (Object item : this.array) {
            if (!(item instanceof Field)) continue;
            this.put((Field)item);
        }
    }

    private void put(Field field) {
        int start;
        Object key = field.getKey();
        Field[] table = this.table;
        int n = table.length;
        int index = start = key != null ? key.hashCode() % n : 0;
        do {
            Field item;
            if ((item = table[index]) != null) {
                Object k = item.getKey();
                if (!(key == null ? k == null : key.equals(k))) continue;
                table[index] = field;
                return;
            }
            table[index] = field;
            return;
        } while ((index = (index + 1) % n) != start);
        throw new AssertionError();
    }

    boolean isBlockSafe() {
        Object[] array = this.array;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (!(array[i] instanceof Attr)) continue;
            return false;
        }
        return true;
    }

    boolean isMarkupSafe() {
        Object[] array = this.array;
        int n = this.size;
        if (n == 0 || !(array[0] instanceof Attr)) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (!(array[i] instanceof Attr)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Field[] access$202(Record x0, Field[] x1) {
        x0.table = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$102(Record x0, Object[] x1) {
        x0.array = x1;
        return x1;
    }

    final class SubList
    implements List<Object> {
        private int fromIndex;
        private int toIndex;

        SubList(int fromIndex, int toIndex) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public int size() {
            return this.toIndex - this.fromIndex;
        }

        @Override
        public boolean contains(Object item) {
            Object[] array = Record.this.array;
            int n = this.toIndex;
            for (int index = this.fromIndex; index < n; ++index) {
                Object x = array[index];
                if (!(item == null ? x == null : item.equals(x))) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<? extends Object> items) {
            HashSet<? extends Object> looking = new HashSet<Object>(items);
            Object[] array = Record.this.array;
            int n = this.toIndex;
            for (int index = this.fromIndex; index < n && !looking.isEmpty(); ++index) {
                looking.remove(array[index]);
            }
            return looking.isEmpty();
        }

        @Override
        public Object get(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return Record.this.array[this.fromIndex + index];
        }

        @Override
        public Object set(int index, Object item) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            Object oldItem = Record.this.array[this.fromIndex + index];
            ((Record)Record.this).array[this.fromIndex + index] = item;
            if (oldItem instanceof Field || item instanceof Field) {
                Record.access$202(Record.this, null);
            }
            return oldItem;
        }

        @Override
        public boolean add(Object item) {
            this.add(this.size(), item);
            return true;
        }

        @Override
        public void add(int index, Object item) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            Object[] array = Record.this.array;
            if (Record.this.size + 1 > array.length) {
                array = new Object[Record.expand(Record.this.size + 1)];
                System.arraycopy(Record.this.array, 0, array, 0, this.fromIndex + index);
            }
            System.arraycopy(Record.this.array, this.fromIndex + index, array, this.fromIndex + index + 1, Record.this.size - this.fromIndex - index);
            array[this.fromIndex + index] = item;
            Record.access$102(Record.this, array);
            if (item instanceof Field) {
                Record.access$202(Record.this, null);
            }
            Record.this.size += 1;
            ++this.toIndex;
        }

        @Override
        public boolean addAll(Collection<? extends Object> items) {
            return this.addAll(this.toIndex, items);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Object> items) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            int n = items.size();
            if (n == 0) {
                return false;
            }
            Object[] array = Record.this.array;
            if (Record.this.size + n > array.length) {
                array = new Object[Record.expand(Record.this.size + n)];
                System.arraycopy(Record.this.array, 0, array, 0, this.fromIndex + index);
            }
            System.arraycopy(Record.this.array, this.fromIndex + index, array, this.fromIndex + index + n, Record.this.size - this.fromIndex - index);
            java.util.Iterator<? extends Object> i$ = items.iterator();
            while (i$.hasNext()) {
                Object item;
                array[this.fromIndex + index] = item = i$.next();
                if (item instanceof Field) {
                    Record.access$202(Record.this, null);
                }
                ++index;
            }
            Record.access$102(Record.this, array);
            Record.this.size += n;
            this.toIndex += n;
            return true;
        }

        @Override
        public Object remove(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            Object[] array = Record.this.array;
            Object oldItem = array[this.fromIndex + index];
            System.arraycopy(array, this.fromIndex + index + 1, array, this.fromIndex + index, Record.this.size - this.fromIndex - index - 1);
            Record.this.size -= 1;
            --this.toIndex;
            array[((Record)Record.this).size] = null;
            if (oldItem instanceof Field) {
                Record.access$202(Record.this, null);
            }
            return oldItem;
        }

        @Override
        public boolean remove(Object item) {
            int index = this.indexOf(item);
            if (index >= 0) {
                this.remove(index);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> items) {
            int i;
            Object[] array = Record.this.array;
            int n = this.toIndex;
            int j = this.fromIndex;
            for (i = this.fromIndex; i < n; ++i) {
                Object item = array[i];
                if (!items.contains(item)) {
                    array[j] = array[i];
                    ++j;
                    continue;
                }
                if (!(item instanceof Field)) continue;
                Record.access$202(Record.this, null);
            }
            this.toIndex = j;
            while (i < Record.this.size) {
                array[j] = array[i];
                ++j;
                ++i;
            }
            if (i > j) {
                while (i > j) {
                    --i;
                    Record.this.size -= 1;
                    array[((Record)Record.this).size] = null;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> items) {
            int i;
            Object[] array = Record.this.array;
            int n = this.toIndex;
            int j = this.fromIndex;
            for (i = this.fromIndex; i < n; ++i) {
                Object item = array[i];
                if (items.contains(item)) {
                    array[j] = array[i];
                    ++j;
                    continue;
                }
                if (!(item instanceof Field)) continue;
                Record.access$202(Record.this, null);
            }
            this.toIndex = j;
            while (i < Record.this.size) {
                array[j] = array[i];
                ++j;
                ++i;
            }
            if (i > j) {
                while (i > j) {
                    --i;
                    Record.this.size -= 1;
                    array[((Record)Record.this).size] = null;
                }
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            Object[] array = Record.this.array;
            int n = Record.this.size;
            int i = this.fromIndex;
            for (int j = this.toIndex; j < n; ++j) {
                Object item;
                array[i] = item = array[j];
                if (item instanceof Field) {
                    Record.access$202(Record.this, null);
                }
                ++i;
            }
            Record.this.size = i;
            this.toIndex = this.fromIndex;
            while (i < n) {
                array[i] = null;
                ++i;
            }
        }

        @Override
        public int indexOf(Object item) {
            Object[] array = Record.this.array;
            int n = this.toIndex;
            for (int index = this.fromIndex; index < n; ++index) {
                Object x = array[index];
                if (!(item == null ? x == null : item.equals(x))) continue;
                return index - this.fromIndex;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object item) {
            Object[] array = Record.this.array;
            for (int index = this.toIndex - 1; index >= this.fromIndex; --index) {
                Object x = array[index];
                if (!(item == null ? x == null : item.equals(x))) continue;
                return index - this.fromIndex;
            }
            return -1;
        }

        @Override
        public List<Object> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException(fromIndex + ", " + toIndex);
            }
            return new SubList(this.fromIndex + fromIndex, this.fromIndex + toIndex);
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            System.arraycopy(Record.this.array, this.fromIndex, array, 0, this.size());
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            if (array.length < this.size()) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size());
            }
            System.arraycopy(Record.this.array, this.fromIndex, array, 0, this.size());
            if (array.length > this.size()) {
                array[this.size()] = null;
            }
            return array;
        }

        @Override
        public java.util.Iterator<Object> iterator() {
            return new Iterator(this.fromIndex, this.fromIndex, this.toIndex);
        }

        @Override
        public ListIterator<Object> listIterator() {
            return new Iterator(this.fromIndex, this.fromIndex, this.toIndex);
        }

        @Override
        public ListIterator<Object> listIterator(int index) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return new Iterator(this.fromIndex + index, this.fromIndex, this.toIndex);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof List)) {
                return false;
            }
            List that = (List)other;
            Object[] array = Record.this.array;
            int n = this.toIndex;
            if (n != that.size()) {
                return false;
            }
            for (int index = this.fromIndex; index < n; ++index) {
                Object i1 = array[index];
                Object i2 = that.get(index - this.fromIndex);
                if (!(i1 == null ? i2 != null : !i1.equals(i2))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            Object[] array = Record.this.array;
            int n = this.toIndex;
            int code = 1;
            for (int index = this.fromIndex; index < n; ++index) {
                Object item = array[index];
                code = 31 * code + (item == null ? 0 : item.hashCode());
            }
            return code;
        }

        public String toString() {
            Object[] array = Record.this.array;
            int n = this.toIndex;
            StringBuilder builder = new StringBuilder("Record.SubList");
            builder.append('(');
            for (int index = this.fromIndex; index < n; ++index) {
                if (index > 0) {
                    builder.append(", ");
                }
                Show.append((StringBuilder)builder, (Object)array[index]);
            }
            builder.append(')');
            return builder.toString();
        }
    }

    final class Iterator
    implements ListIterator<Object> {
        private int index;
        private int fromIndex;
        private int toIndex;
        private int direction;

        Iterator(int index, int fromIndex, int toIndex) {
            this.index = index;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.direction = 0;
        }

        Iterator(int index) {
            this.index = index;
            this.fromIndex = 0;
            this.toIndex = Record.this.size;
            this.direction = 0;
        }

        Iterator() {
            this.index = 0;
            this.fromIndex = 0;
            this.toIndex = Record.this.size;
            this.direction = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.toIndex;
        }

        @Override
        public int nextIndex() {
            return this.index - this.fromIndex;
        }

        @Override
        public Object next() {
            if (this.index < this.fromIndex || this.index >= this.toIndex) {
                throw new NoSuchElementException();
            }
            Object item = Record.this.array[this.index];
            ++this.index;
            this.direction = 1;
            return item;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > this.fromIndex;
        }

        @Override
        public int previousIndex() {
            return this.index - this.fromIndex - 1;
        }

        @Override
        public Object previous() {
            if (this.index <= this.fromIndex || this.index > this.toIndex) {
                throw new NoSuchElementException();
            }
            --this.index;
            this.direction = -1;
            return Record.this.array[this.index];
        }

        @Override
        public void add(Object item) {
            Record.this.add(this.index, item);
            ++this.index;
            this.direction = 0;
        }

        @Override
        public void set(Object item) {
            if (this.direction == 0) {
                throw new IllegalStateException();
            }
            if (this.direction > 0) {
                Record.this.set(this.index - 1, item);
            } else {
                Record.this.set(this.index, item);
            }
        }

        @Override
        public void remove() {
            if (this.direction == 0) {
                throw new IllegalStateException();
            }
            if (this.direction > 0) {
                --this.index;
            }
            Record.this.remove(this.index);
            this.direction = 0;
        }
    }
}

