/*
 * Decompiled with CFR 0.152.
 */
package it.swim.recon;

import it.swim.recon.Attr;
import it.swim.recon.Extant;
import it.swim.recon.Field;
import it.swim.recon.ReconParser;
import it.swim.recon.Record;
import java.nio.ByteBuffer;

abstract class ReconWriter {
    ReconWriter() {
    }

    protected abstract void writeCodePoint(int var1);

    protected void writeLiteral(String literal) {
        int n = literal.length();
        int i = 0;
        while (i < n) {
            this.writeCodePoint(literal.codePointAt(i));
            i = literal.offsetByCodePoints(i, 1);
        }
    }

    public void writeItem(Object item) {
        if (item instanceof Field) {
            this.writeSlot((Field)item);
        } else {
            this.writeValue(item);
        }
    }

    public void writeValue(Object value) {
        if (value instanceof Record) {
            this.writeRecord((Record)value);
        } else if (value instanceof String) {
            this.writeText((String)value);
        } else if (value instanceof Number) {
            this.writeNumber((Number)value);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof ByteBuffer) {
            this.writeData((ByteBuffer)value);
        } else if (value instanceof Extant || value == null) {
            // empty if block
        }
    }

    public void writeAttr(Attr field) {
        this.writeCodePoint(64);
        this.writeIdent(field.getKey());
        if (!(field.getValue() instanceof Extant)) {
            this.writeCodePoint(40);
            this.writeBlock(field.getValue());
            this.writeCodePoint(41);
        }
    }

    public void writeSlot(Field field) {
        this.writeValue(field.getKey());
        this.writeCodePoint(58);
        if (field.getValue() != null) {
            this.writeValue(field.getValue());
        }
    }

    protected void writeItems(Record items, boolean inBlock, boolean inMarkup) {
        int i = 0;
        int n = items.size();
        boolean inBraces = false;
        boolean inBrackets = false;
        boolean first = true;
        while (i < n) {
            Object item = items.get(i);
            ++i;
            if (inBrackets && item instanceof Attr) {
                if (inBraces) {
                    this.writeCodePoint(125);
                    inBraces = false;
                }
                this.writeCodePoint(93);
                inBrackets = false;
            }
            if (item instanceof Attr) {
                if (inBraces) {
                    this.writeCodePoint(125);
                    inBraces = false;
                } else if (inBrackets) {
                    this.writeCodePoint(93);
                    inBrackets = false;
                }
                this.writeAttr((Attr)item);
                first = false;
                continue;
            }
            if (inBrackets && item instanceof String) {
                if (inBraces) {
                    this.writeCodePoint(125);
                    inBraces = false;
                }
                this.writeMarkupText((String)item);
                continue;
            }
            if (inBraces) {
                if (!first) {
                    this.writeCodePoint(44);
                } else {
                    first = false;
                }
                this.writeItem(item);
                continue;
            }
            if (inBrackets) {
                if (item instanceof Record && ((Record)item).isMarkupSafe()) {
                    this.writeItems((Record)item, false, true);
                    if (i < n && items.get(i) instanceof String) {
                        this.writeMarkupText((String)items.get(i));
                        ++i;
                        continue;
                    }
                    if (i < n && !(items.get(i) instanceof Attr)) {
                        this.writeCodePoint(123);
                        inBraces = true;
                        first = true;
                        continue;
                    }
                    this.writeCodePoint(93);
                    inBrackets = false;
                    continue;
                }
                this.writeCodePoint(123);
                this.writeItem(item);
                inBraces = true;
                first = false;
                continue;
            }
            if (item instanceof String && i < n && !(items.get(i) instanceof Field) && !(items.get(i) instanceof String) && !(items.get(i) instanceof Boolean)) {
                this.writeCodePoint(91);
                this.writeMarkupText((String)item);
                inBrackets = true;
                continue;
            }
            if (inBlock && !inBraces) {
                if (!first) {
                    this.writeCodePoint(44);
                } else {
                    first = false;
                }
                this.writeItem(item);
                continue;
            }
            if (inMarkup && item instanceof String && i >= n) {
                this.writeCodePoint(91);
                this.writeMarkupText((String)item);
                this.writeCodePoint(93);
                continue;
            }
            if (!inMarkup && !(item instanceof Field) && !(item instanceof Record) && (!first && i >= n || i < n && items.get(i) instanceof Attr)) {
                if (!first && (item instanceof String && this.isIdent((String)item) || item instanceof Number || item instanceof Boolean)) {
                    this.writeCodePoint(32);
                }
                this.writeValue(item);
                continue;
            }
            this.writeCodePoint(123);
            this.writeItem(item);
            inBraces = true;
            first = false;
        }
        if (inBraces) {
            this.writeCodePoint(125);
        } else if (inBrackets) {
            this.writeCodePoint(93);
        }
    }

    public void writeBlock(Object value) {
        if (value instanceof Record) {
            Record record = (Record)value;
            if (!record.isEmpty()) {
                this.writeItems(record, record.isBlockSafe(), false);
            } else {
                this.writeCodePoint(123);
                this.writeCodePoint(125);
            }
        } else {
            this.writeValue(value);
        }
    }

    public void writeRecord(Record record) {
        if (!record.isEmpty()) {
            this.writeItems(record, false, false);
        } else {
            this.writeCodePoint(123);
            this.writeCodePoint(125);
        }
    }

    public void writeText(String text) {
        if (this.isIdent(text)) {
            this.writeIdent(text);
        } else {
            this.writeString(text);
        }
    }

    protected void writeIdent(String ident) {
        this.writeLiteral(ident);
    }

    protected void writeString(String string) {
        int n = string.length();
        this.writeCodePoint(34);
        int i = 0;
        while (i < n) {
            int c = string.codePointAt(i);
            switch (c) {
                case 34: 
                case 92: {
                    this.writeCodePoint(92);
                    this.writeCodePoint(c);
                    break;
                }
                case 8: {
                    this.writeCodePoint(92);
                    this.writeCodePoint(98);
                    break;
                }
                case 12: {
                    this.writeCodePoint(92);
                    this.writeCodePoint(102);
                    break;
                }
                case 10: {
                    this.writeCodePoint(92);
                    this.writeCodePoint(110);
                    break;
                }
                case 13: {
                    this.writeCodePoint(92);
                    this.writeCodePoint(114);
                    break;
                }
                case 9: {
                    this.writeCodePoint(92);
                    this.writeCodePoint(116);
                    break;
                }
                default: {
                    this.writeCodePoint(c);
                }
            }
            i = string.offsetByCodePoints(i, 1);
        }
        this.writeCodePoint(34);
    }

    protected void writeMarkupText(String text) {
        int n = text.length();
        int i = 0;
        while (i < n) {
            int c = text.codePointAt(i);
            switch (c) {
                case 64: 
                case 91: 
                case 92: 
                case 93: 
                case 123: 
                case 125: {
                    this.writeCodePoint(92);
                    this.writeCodePoint(c);
                    break;
                }
                default: {
                    this.writeCodePoint(c);
                }
            }
            i = text.offsetByCodePoints(i, 1);
        }
    }

    public void writeNumber(Number number) {
        this.writeLiteral(number.toString());
    }

    public void writeBoolean(boolean value) {
        this.writeLiteral(value ? "true" : "false");
    }

    private int encodeBase64Digit(int x) {
        if (x >= 0 && x < 26) {
            return x + 65;
        }
        if (x >= 26 && x < 52) {
            return x + 71;
        }
        if (x >= 52 && x < 62) {
            return x + -4;
        }
        if (x == 62) {
            return 43;
        }
        if (x == 63) {
            return 47;
        }
        throw new AssertionError();
    }

    public void writeData(ByteBuffer data) {
        int y;
        int x;
        this.writeCodePoint(37);
        int i = data.position();
        int n = data.limit();
        while (i + 2 < n) {
            x = data.get(i) & 0xFF;
            y = data.get(i + 1) & 0xFF;
            int z = data.get(i + 2) & 0xFF;
            this.writeCodePoint(this.encodeBase64Digit(x >>> 2));
            this.writeCodePoint(this.encodeBase64Digit((x << 4 | y >>> 4) & 0x3F));
            this.writeCodePoint(this.encodeBase64Digit((y << 2 | z >>> 6) & 0x3F));
            this.writeCodePoint(this.encodeBase64Digit(z & 0x3F));
            i += 3;
        }
        if (i + 1 < n) {
            x = data.get(i) & 0xFF;
            y = data.get(i + 1) & 0xFF;
            this.writeCodePoint(this.encodeBase64Digit(x >>> 2));
            this.writeCodePoint(this.encodeBase64Digit((x << 4 | y >>> 4) & 0x3F));
            this.writeCodePoint(this.encodeBase64Digit(y << 2 & 0x3F));
            this.writeCodePoint(61);
            i += 2;
        } else if (i < n) {
            x = data.get(i) & 0xFF;
            this.writeCodePoint(this.encodeBase64Digit(x >>> 2));
            this.writeCodePoint(this.encodeBase64Digit(x << 4 & 0x3F));
            this.writeCodePoint(61);
            this.writeCodePoint(61);
            ++i;
        }
    }

    protected boolean isIdent(String text) {
        int n = text.length();
        if (n == 0 || !ReconParser.isNameStartChar(text.codePointAt(0))) {
            return false;
        }
        int i = text.offsetByCodePoints(0, 1);
        while (i < n) {
            if (!ReconParser.isNameChar(text.codePointAt(i))) {
                return false;
            }
            i = text.offsetByCodePoints(i, 1);
        }
        return true;
    }
}

