/*
 * Decompiled with CFR 0.152.
 */
package it.swim.recon;

import it.swim.recon.ReconException;
import it.swim.recon.ReconFactory;
import it.swim.util.Input;
import it.swim.util.Iteratee;

public abstract class ReconParser
implements ReconFactory {
    public final Iteratee<Object> documentParser = new DocumentParser();
    public final Iteratee<Object> blockParser = new BlockParser();
    public final Iteratee<Object> attrParser = new AttrParser();
    public final Iteratee<Object> blockValueParser = new BlockValueParser();
    public final Iteratee<Object> inlineValueParser = new InlineValueParser();
    public final Iteratee<Object> recordParser = new RecordParser();
    public final Iteratee<Object> markupParser = new MarkupParser();
    public final Iteratee<Object> identParser = new IdentParser();
    public final Iteratee<Object> stringParser = new StringParser();
    public final Iteratee<Object> numberParser = new NumberParser();
    public final Iteratee<Object> dataParser = new DataParser();

    public Iteratee<Object> recordParser(ReconFactory.ItemBuilder builder) {
        return new RecordParser(builder);
    }

    public Iteratee<Object> markupParser(ReconFactory.ItemBuilder builder) {
        return new MarkupParser(builder);
    }

    static boolean isSpace(int c) {
        return c == 32 || c == 9;
    }

    static boolean isNewline(int c) {
        return c == 10 || c == 13;
    }

    static boolean isWhitespace(int c) {
        return ReconParser.isSpace(c) || ReconParser.isNewline(c);
    }

    static boolean isNameStartChar(int c) {
        return c >= 65 && c <= 90 || c == 95 || c >= 97 && c <= 122 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    static boolean isNameChar(int c) {
        return c == 45 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c == 95 || c >= 97 && c <= 122 || c == 183 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8255 && c <= 8256 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    static boolean isBase64Char(int c) {
        return c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 43 || c == 45 || c == 47 || c == 95;
    }

    protected class DataParser
    extends Parser {
        protected final ReconFactory.DataBuilder data;
        protected final int s;

        protected DataParser(ReconFactory.DataBuilder data, int s) {
            this.data = data;
            this.s = s;
        }

        protected DataParser() {
            this(null, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Iteratee<Object> feed(Input input) {
            ReconFactory.DataBuilder data;
            int c = 0;
            int s = this.s;
            ReconFactory.DataBuilder dataBuilder = data = this.data != null ? this.data : ReconParser.this.dataBuilder();
            if (s == 1) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c != 37) return DataParser.expected(input, 37, c);
                    input.step();
                    s = 2;
                } else if (input.isDone()) {
                    return DataParser.unexpectedEOF();
                }
            }
            while (!input.isEmpty() || input.isDone()) {
                if (s == 2) {
                    if (!input.isEmpty()) {
                        c = input.head();
                        if (!ReconParser.isBase64Char(c)) return DataParser.done((Object)data.result());
                        input.step();
                        data.appendCodePoint(c);
                        s = 3;
                    } else if (input.isDone()) {
                        return DataParser.done((Object)data.result());
                    }
                }
                if (s == 3) {
                    if (input.isEmpty()) return DataParser.unexpectedEOF();
                    c = input.head();
                    if (!ReconParser.isBase64Char(c)) return DataParser.expected(input, "base64 digit", c);
                    input.step();
                    data.appendCodePoint(c);
                    s = 4;
                }
                if (s == 4) {
                    if (input.isEmpty()) return DataParser.unexpectedEOF();
                    c = input.head();
                    if (!ReconParser.isBase64Char(c) && c != 61) return DataParser.expected(input, "base64 digit", c);
                    input.step();
                    data.appendCodePoint(c);
                    s = c != 61 ? 5 : 6;
                }
                if (s == 5) {
                    if (input.isEmpty()) return DataParser.unexpectedEOF();
                    c = input.head();
                    if (!ReconParser.isBase64Char(c) && c != 61) return DataParser.expected(input, "base64 digit", c);
                    input.step();
                    data.appendCodePoint(c);
                    if (c == 61) return DataParser.done((Object)data.result());
                    s = 2;
                    continue;
                }
                if (s != 6) continue;
                if (input.isEmpty()) return DataParser.unexpectedEOF();
                c = input.head();
                if (c != 61) return DataParser.expected(input, 61, c);
                input.step();
                data.appendCodePoint(c);
                return DataParser.done((Object)data.result());
            }
            return new DataParser(data, s);
        }
    }

    protected class NumberParser
    extends Parser {
        protected final StringBuilder builder;
        protected final int s;

        protected NumberParser(StringBuilder builder, int s) {
            this.builder = builder;
            this.s = s;
        }

        protected NumberParser() {
            this(null, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Iteratee<Object> feed(Input input) {
            StringBuilder builder;
            int c = 0;
            int s = this.s;
            StringBuilder stringBuilder = builder = this.builder != null ? this.builder : new StringBuilder();
            if (s == 1) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c == 45) {
                        input.step();
                        builder.appendCodePoint(c);
                    }
                    s = 2;
                } else if (input.isDone()) {
                    return NumberParser.unexpectedEOF();
                }
            }
            if (s == 2) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c == 48) {
                        input.step();
                        builder.appendCodePoint(c);
                        s = 4;
                    } else {
                        if (c < 49 || c > 57) return NumberParser.expected(input, "digit", c);
                        input.step();
                        builder.appendCodePoint(c);
                        s = 3;
                    }
                } else if (input.isDone()) {
                    return NumberParser.unexpectedEOF();
                }
            }
            if (s == 3) {
                while (!input.isEmpty() && (c = input.head()) >= 48 && c <= 57) {
                    input.step();
                    builder.appendCodePoint(c);
                }
                if (!input.isEmpty()) {
                    s = 4;
                } else if (input.isDone()) {
                    return NumberParser.done((Object)ReconParser.this.number(builder.toString()));
                }
            }
            if (s == 4) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c == 46) {
                        input.step();
                        builder.appendCodePoint(c);
                        s = 5;
                    } else {
                        if (c != 69 && c != 101) return NumberParser.done((Object)ReconParser.this.number(builder.toString()));
                        input.step();
                        builder.appendCodePoint(c);
                        s = 8;
                    }
                } else if (input.isDone()) {
                    return NumberParser.done((Object)ReconParser.this.number(builder.toString()));
                }
            }
            if (s == 5) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c < 48 || c > 57) return NumberParser.expected(input, "digit", c);
                    input.step();
                    builder.appendCodePoint(c);
                    s = 6;
                } else if (input.isDone()) {
                    return NumberParser.unexpectedEOF();
                }
            }
            if (s == 6) {
                while (!input.isEmpty() && (c = input.head()) >= 48 && c <= 57) {
                    input.step();
                    builder.appendCodePoint(c);
                }
                if (!input.isEmpty()) {
                    s = 7;
                } else if (input.isDone()) {
                    return NumberParser.done((Object)ReconParser.this.number(builder.toString()));
                }
            }
            if (s == 7) {
                c = input.head();
                if (c != 69 && c != 101) return NumberParser.done((Object)ReconParser.this.number(builder.toString()));
                input.step();
                builder.appendCodePoint(c);
                s = 8;
            }
            if (s == 8) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c == 43 || c == 45) {
                        input.step();
                        builder.appendCodePoint(c);
                    }
                    s = 9;
                } else if (input.isDone()) {
                    return NumberParser.unexpectedEOF();
                }
            }
            if (s == 9) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c < 48 || c > 57) return NumberParser.expected(input, "digit", c);
                    input.step();
                    builder.appendCodePoint(c);
                    s = 10;
                } else if (input.isDone()) {
                    return NumberParser.unexpectedEOF();
                }
            }
            if (s != 10) return new NumberParser(builder, s);
            while (!input.isEmpty()) {
                c = input.head();
                if (c < 48 || c > 57) continue;
                input.step();
                builder.appendCodePoint(c);
            }
            if (input.isEmpty() && !input.isDone()) return new NumberParser(builder, s);
            return NumberParser.done((Object)ReconParser.this.number(builder.toString()));
        }
    }

    protected class StringParser
    extends Parser {
        protected final ReconFactory.TextBuilder text;
        protected final int s;

        protected StringParser(ReconFactory.TextBuilder text, int s) {
            this.text = text;
            this.s = s;
        }

        protected StringParser() {
            this(null, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Iteratee<Object> feed(Input input) {
            int c = 0;
            int s = this.s;
            ReconFactory.TextBuilder text = this.text;
            if (s == 1) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c != 34) return StringParser.expected(input, 34, c);
                    input.step();
                    s = 2;
                } else if (input.isDone()) {
                    return StringParser.unexpectedEOF();
                }
            }
            while (!input.isEmpty() || input.isDone()) {
                if (s == 2) {
                    if (text == null) {
                        text = ReconParser.this.textBuilder();
                    }
                    while (!input.isEmpty() && (c = input.head()) != 34 && c != 92) {
                        input.step();
                        text.appendCodePoint(c);
                    }
                    if (!input.isEmpty()) {
                        if (c == 34) {
                            input.step();
                            return StringParser.done((Object)text.result());
                        }
                        if (c == 92) {
                            input.step();
                            s = 3;
                        }
                    } else if (input.isDone()) {
                        return StringParser.unexpectedEOF();
                    }
                }
                if (s != 3) continue;
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c == 34 || c == 47 || c == 64 || c == 91 || c == 92 || c == 93 || c == 123 || c == 125) {
                        input.step();
                        text.appendCodePoint(c);
                        s = 2;
                        continue;
                    }
                    if (c == 98) {
                        input.step();
                        text.appendCodePoint(8);
                        s = 2;
                        continue;
                    }
                    if (c == 102) {
                        input.step();
                        text.appendCodePoint(12);
                        s = 2;
                        continue;
                    }
                    if (c == 110) {
                        input.step();
                        text.appendCodePoint(10);
                        s = 2;
                        continue;
                    }
                    if (c == 114) {
                        input.step();
                        text.appendCodePoint(13);
                        s = 2;
                        continue;
                    }
                    if (c != 116) return StringParser.expected(input, "escape character", c);
                    input.step();
                    text.appendCodePoint(9);
                    s = 2;
                    continue;
                }
                if (!input.isDone()) continue;
                return StringParser.unexpectedEOF();
            }
            return new StringParser(text, s);
        }
    }

    protected class IdentParser
    extends Parser {
        protected final ReconFactory.TextBuilder builder;
        protected final int s;

        protected IdentParser(ReconFactory.TextBuilder builder, int s) {
            this.builder = builder;
            this.s = s;
        }

        protected IdentParser() {
            this(null, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Iteratee<Object> feed(Input input) {
            int c = 0;
            int s = this.s;
            ReconFactory.TextBuilder builder = this.builder;
            if (s == 1) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (!ReconParser.isNameStartChar(c)) return IdentParser.expected(input, "identifier", c);
                    if (builder == null) {
                        builder = ReconParser.this.textBuilder();
                    }
                    input.step();
                    builder.appendCodePoint(c);
                    s = 2;
                } else if (input.isDone()) {
                    return IdentParser.unexpectedEOF();
                }
            }
            if (s != 2) return new IdentParser(builder, s);
            while (!input.isEmpty() && ReconParser.isNameChar(c = input.head())) {
                input.step();
                builder.appendCodePoint(c);
            }
            if (input.isEmpty() && !input.isDone()) return new IdentParser(builder, s);
            return IdentParser.done((Object)builder.result());
        }
    }

    protected class MarkupParser
    extends Parser {
        protected final ReconFactory.ItemBuilder builder;
        protected final ReconFactory.TextBuilder text;
        protected final Iteratee<Object> value;
        protected final int s;

        protected MarkupParser(ReconFactory.ItemBuilder builder, ReconFactory.TextBuilder text, Iteratee<Object> value, int s) {
            this.builder = builder;
            this.text = text;
            this.value = value;
            this.s = s;
        }

        protected MarkupParser(ReconFactory.ItemBuilder builder) {
            this(builder, null, null, 1);
        }

        protected MarkupParser() {
            this(null, null, null, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Iteratee<Object> feed(Input input) {
            int c = 0;
            int s = this.s;
            Iteratee<Object> value = this.value;
            ReconFactory.TextBuilder text = this.text;
            ReconFactory.ItemBuilder builder = this.builder;
            if (s == 1) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c != 91) return MarkupParser.expected(input, 91, c);
                    input.step();
                    s = 2;
                } else if (input.isDone()) {
                    return MarkupParser.unexpectedEOF();
                }
            }
            while (!input.isEmpty() || input.isDone()) {
                if (s == 2) {
                    while (!input.isEmpty() && (c = input.head()) != 64 && c != 91 && c != 92 && c != 93 && c != 123 && c != 125) {
                        input.step();
                        if (text == null) {
                            text = ReconParser.this.textBuilder();
                        }
                        text.appendCodePoint(c);
                    }
                    if (!input.isEmpty()) {
                        if (c == 93) {
                            input.step();
                            if (builder == null) {
                                builder = ReconParser.this.recordBuilder();
                            }
                            if (text == null) return MarkupParser.done((Object)builder.result());
                            builder.appendValue(text.result());
                            return MarkupParser.done((Object)builder.result());
                        }
                        if (c == 64) {
                            if (builder == null) {
                                builder = ReconParser.this.recordBuilder();
                            }
                            if (text != null) {
                                builder.appendValue(text.result());
                                text = null;
                            }
                            value = ReconParser.this.inlineValueParser;
                            s = 3;
                        } else if (c == 123) {
                            if (builder == null) {
                                builder = ReconParser.this.recordBuilder();
                            }
                            if (text != null) {
                                builder.appendValue(text.result());
                                text = null;
                            }
                            value = ReconParser.this.recordParser(builder);
                            s = 4;
                        } else if (c == 91) {
                            if (builder == null) {
                                builder = ReconParser.this.recordBuilder();
                            }
                            if (text != null) {
                                builder.appendValue(text.result());
                                text = null;
                            }
                            value = ReconParser.this.markupParser(builder);
                            s = 4;
                        } else {
                            if (c != 92) return MarkupParser.unexpected(input, c);
                            input.step();
                            s = 5;
                        }
                    } else if (input.isDone()) {
                        return MarkupParser.unexpectedEOF();
                    }
                }
                if (s == 3) {
                    while ((!input.isEmpty() || input.isDone()) && value.isCont()) {
                        value = value.feed(input);
                    }
                    if (value.isDone()) {
                        builder.appendValue(value.bind());
                        value = null;
                        s = 2;
                    } else if (value.isError()) {
                        return value;
                    }
                }
                if (s == 4) {
                    while ((!input.isEmpty() || input.isDone()) && value.isCont()) {
                        value = value.feed(input);
                    }
                    if (value.isDone()) {
                        value = null;
                        s = 2;
                    } else if (value.isError()) {
                        return value;
                    }
                }
                if (s != 5) continue;
                if (!input.isEmpty()) {
                    c = input.head();
                    if (text == null) {
                        text = ReconParser.this.textBuilder();
                    }
                    if (c == 34 || c == 47 || c == 64 || c == 91 || c == 92 || c == 93 || c == 123 || c == 125) {
                        input.step();
                        text.appendCodePoint(c);
                        s = 2;
                        continue;
                    }
                    if (c == 98) {
                        input.step();
                        text.appendCodePoint(8);
                        s = 2;
                        continue;
                    }
                    if (c == 102) {
                        input.step();
                        text.appendCodePoint(12);
                        s = 2;
                        continue;
                    }
                    if (c == 110) {
                        input.step();
                        text.appendCodePoint(10);
                        s = 2;
                        continue;
                    }
                    if (c == 114) {
                        input.step();
                        text.appendCodePoint(13);
                        s = 2;
                        continue;
                    }
                    if (c != 116) return MarkupParser.expected(input, "escape character", c);
                    input.step();
                    text.appendCodePoint(9);
                    s = 2;
                    continue;
                }
                if (!input.isDone()) continue;
                return MarkupParser.unexpectedEOF();
            }
            return new MarkupParser(builder, text, value, s);
        }
    }

    protected class RecordParser
    extends Parser {
        protected final ReconFactory.ItemBuilder builder;
        protected final Iteratee<Object> key;
        protected final Iteratee<Object> value;
        protected final int s;

        protected RecordParser(ReconFactory.ItemBuilder builder, Iteratee<Object> key, Iteratee<Object> value, int s) {
            this.builder = builder;
            this.key = key;
            this.value = value;
            this.s = s;
        }

        protected RecordParser(ReconFactory.ItemBuilder builder) {
            this(builder, null, null, 1);
        }

        protected RecordParser() {
            this(null, null, null, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Iteratee<Object> feed(Input input) {
            ReconFactory.ItemBuilder builder;
            int c = 0;
            int s = this.s;
            Iteratee value = this.value;
            Iteratee key = this.key;
            ReconFactory.ItemBuilder itemBuilder = builder = this.builder != null ? this.builder : ReconParser.this.recordBuilder();
            if (s == 1) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c != 123) return RecordParser.expected(input, 123, c);
                    input.step();
                    s = 2;
                } else if (input.isDone()) {
                    return RecordParser.unexpectedEOF();
                }
            }
            while (!input.isEmpty() || input.isDone()) {
                if (s == 2) {
                    while (!input.isEmpty() && ReconParser.isWhitespace(c = input.head())) {
                        input.step();
                    }
                    if (!input.isEmpty()) {
                        if (c == 125) {
                            input.step();
                            return RecordParser.done((Object)builder.result());
                        }
                        s = 3;
                    } else if (input.isDone()) {
                        return RecordParser.unexpectedEOF();
                    }
                }
                if (s == 3) {
                    if (key == null) {
                        key = ReconParser.this.blockValueParser;
                    }
                    while ((!input.isEmpty() || input.isDone()) && key.isCont()) {
                        key = key.feed(input);
                    }
                    if (key.isDone()) {
                        s = 4;
                    } else if (key.isError()) {
                        return key;
                    }
                }
                if (s == 4) {
                    while (!input.isEmpty() && ReconParser.isSpace(c = input.head())) {
                        input.step();
                    }
                    if (!input.isEmpty()) {
                        if (c == 58) {
                            input.step();
                            s = 5;
                        } else {
                            builder.appendValue(key.bind());
                            key = null;
                            s = 7;
                        }
                    } else if (input.isDone()) {
                        return RecordParser.unexpectedEOF();
                    }
                }
                if (s == 5) {
                    while (!input.isEmpty() && ReconParser.isSpace(input.head())) {
                        input.step();
                    }
                    if (!input.isEmpty()) {
                        s = 6;
                    } else if (input.isDone()) {
                        builder.appendField(ReconParser.this.slot(key.bind()));
                        return RecordParser.done((Object)builder.result());
                    }
                }
                if (s == 6) {
                    if (value == null) {
                        value = ReconParser.this.blockValueParser;
                    }
                    while ((!input.isEmpty() || input.isDone()) && value.isCont()) {
                        value = value.feed(input);
                    }
                    if (value.isDone()) {
                        builder.appendField(ReconParser.this.slot(key.bind(), value.bind()));
                        key = null;
                        value = null;
                        s = 7;
                    } else if (value.isError()) {
                        return value;
                    }
                }
                if (s != 7) continue;
                while (!input.isEmpty() && ReconParser.isSpace(c = input.head())) {
                    input.step();
                }
                if (!input.isEmpty()) {
                    if (c == 44 || c == 59 || ReconParser.isNewline(c)) {
                        input.step();
                        s = 2;
                        continue;
                    }
                    if (c != 125) return RecordParser.expected(input, "'}', ';', ',', or newline", c);
                    input.step();
                    return RecordParser.done((Object)builder.result());
                }
                if (!input.isDone()) continue;
                return RecordParser.unexpectedEOF();
            }
            return new RecordParser(builder, key, value, s);
        }
    }

    protected class InlineValueParser
    extends Parser {
        protected final ReconFactory.ItemBuilder builder;
        protected final Iteratee<Object> field;
        protected final Iteratee<Object> value;
        protected final int s;

        protected InlineValueParser(ReconFactory.ItemBuilder builder, Iteratee<Object> field, Iteratee<Object> value, int s) {
            this.builder = builder;
            this.field = field;
            this.value = value;
            this.s = s;
        }

        protected InlineValueParser() {
            this(null, null, null, 1);
        }

        /*
         * Enabled aggressive block sorting
         */
        public Iteratee<Object> feed(Input input) {
            ReconFactory.ItemBuilder builder;
            Iteratee field;
            Iteratee<Object> value;
            int s;
            int c;
            block31: {
                block33: {
                    block35: {
                        block34: {
                            c = 0;
                            s = this.s;
                            value = this.value;
                            field = this.field;
                            builder = this.builder;
                            if (s != 1) break block31;
                            if (input.isEmpty()) break block33;
                            c = input.head();
                            if (c != 64) break block34;
                            field = ReconParser.this.attrParser;
                            s = 2;
                            break block31;
                        }
                        if (c != 123) break block35;
                        if (builder != null) {
                            value = ReconParser.this.recordParser(builder);
                            s = 5;
                            break block31;
                        } else {
                            value = ReconParser.this.recordParser;
                            s = 4;
                        }
                        break block31;
                    }
                    if (c == 91) {
                        if (builder != null) {
                            value = ReconParser.this.markupParser(builder);
                            s = 5;
                            break block31;
                        } else {
                            value = ReconParser.this.markupParser;
                            s = 4;
                        }
                        break block31;
                    } else {
                        if (builder == null) {
                            return InlineValueParser.done((Object)ReconParser.this.extant());
                        }
                        return InlineValueParser.done((Object)builder.result());
                    }
                }
                if (input.isDone()) {
                    if (builder == null) {
                        return InlineValueParser.done((Object)ReconParser.this.extant());
                    }
                    return InlineValueParser.done((Object)builder.result());
                }
            }
            if (s == 2) {
                while ((!input.isEmpty() || input.isDone()) && field.isCont()) {
                    field = field.feed(input);
                }
                if (field.isDone()) {
                    if (builder == null) {
                        builder = ReconParser.this.valueBuilder();
                    }
                    builder.appendField(field.bind());
                    field = null;
                    s = 3;
                } else if (field.isError()) {
                    return field;
                }
            }
            if (s == 3) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c == 123) {
                        value = ReconParser.this.recordParser(builder);
                        s = 5;
                    } else {
                        if (c != 91) {
                            return InlineValueParser.done((Object)builder.result());
                        }
                        value = ReconParser.this.markupParser(builder);
                        s = 5;
                    }
                } else if (input.isDone()) {
                    return InlineValueParser.done((Object)builder.result());
                }
            }
            if (s == 4) {
                while ((!input.isEmpty() || input.isDone()) && value.isCont()) {
                    value = value.feed(input);
                }
                if (value.isDone()) {
                    if (builder == null) {
                        builder = ReconParser.this.valueBuilder();
                    }
                    builder.appendValue(value.bind());
                    return InlineValueParser.done((Object)builder.result());
                }
                if (value.isError()) {
                    return value;
                }
            }
            if (s == 5) {
                while ((!input.isEmpty() || input.isDone()) && value.isCont()) {
                    value = value.feed(input);
                }
                if (value.isDone()) {
                    return InlineValueParser.done((Object)builder.result());
                }
                if (value.isError()) {
                    return value;
                }
            }
            return new InlineValueParser(builder, (Iteratee<Object>)field, value, s);
        }
    }

    protected class BlockValueParser
    extends Parser {
        protected final ReconFactory.ItemBuilder builder;
        protected final Iteratee<Object> field;
        protected final Iteratee<Object> value;
        protected final int s;

        protected BlockValueParser(ReconFactory.ItemBuilder builder, Iteratee<Object> field, Iteratee<Object> value, int s) {
            this.builder = builder;
            this.field = field;
            this.value = value;
            this.s = s;
        }

        protected BlockValueParser() {
            this(null, null, null, 1);
        }

        /*
         * Enabled aggressive block sorting
         */
        public Iteratee<Object> feed(Input input) {
            int c = 0;
            int s = this.s;
            Iteratee<Object> value = this.value;
            Iteratee field = this.field;
            ReconFactory.ItemBuilder builder = this.builder;
            while (true) {
                block34: {
                    block35: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        block36: {
                                            if (input.isEmpty() && !input.isDone()) {
                                                return new BlockValueParser(builder, field, value, s);
                                            }
                                            if (s != 1) break block34;
                                            if (input.isEmpty()) break block35;
                                            c = input.head();
                                            if (c != 64) break block36;
                                            field = ReconParser.this.attrParser;
                                            s = 2;
                                            break block34;
                                        }
                                        if (c != 123) break block37;
                                        if (builder == null) {
                                            builder = ReconParser.this.recordBuilder();
                                        }
                                        value = ReconParser.this.recordParser(builder);
                                        s = 5;
                                        break block34;
                                    }
                                    if (c != 91) break block38;
                                    if (builder == null) {
                                        builder = ReconParser.this.recordBuilder();
                                    }
                                    value = ReconParser.this.markupParser(builder);
                                    s = 5;
                                    break block34;
                                }
                                if (!ReconParser.isNameStartChar(c)) break block39;
                                value = ReconParser.this.identParser;
                                s = 4;
                                break block34;
                            }
                            if (c != 34) break block40;
                            value = ReconParser.this.stringParser;
                            s = 4;
                            break block34;
                        }
                        if (c == 45 || c >= 48 && c <= 57) {
                            value = ReconParser.this.numberParser;
                            s = 4;
                            break block34;
                        } else if (c == 37) {
                            value = ReconParser.this.dataParser;
                            s = 4;
                            break block34;
                        } else {
                            if (builder == null) {
                                return BlockValueParser.done((Object)ReconParser.this.extant());
                            }
                            return BlockValueParser.done((Object)builder.result());
                        }
                    }
                    if (input.isDone()) {
                        if (builder == null) {
                            return BlockValueParser.done((Object)ReconParser.this.extant());
                        }
                        return BlockValueParser.done((Object)builder.result());
                    }
                }
                if (s == 2) {
                    while ((!input.isEmpty() || input.isDone()) && field.isCont()) {
                        field = field.feed(input);
                    }
                    if (field.isDone()) {
                        if (builder == null) {
                            builder = ReconParser.this.valueBuilder();
                        }
                        builder.appendField(field.bind());
                        field = null;
                        s = 3;
                    } else if (field.isError()) {
                        return field;
                    }
                }
                if (s == 3) {
                    while (!input.isEmpty() && ReconParser.isSpace(input.head())) {
                        input.step();
                    }
                    if (!input.isEmpty()) {
                        s = 1;
                    } else if (input.isDone()) {
                        return BlockValueParser.done((Object)builder.result());
                    }
                }
                if (s == 4) {
                    while ((!input.isEmpty() || input.isDone()) && value.isCont()) {
                        value = value.feed(input);
                    }
                    if (value.isDone()) {
                        if (builder == null) {
                            builder = ReconParser.this.valueBuilder();
                        }
                        builder.appendValue(value.bind());
                        value = null;
                        s = 6;
                    } else if (value.isError()) {
                        return value;
                    }
                }
                if (s == 5) {
                    while ((!input.isEmpty() || input.isDone()) && value.isCont()) {
                        value = value.feed(input);
                    }
                    if (value.isDone()) {
                        value = null;
                        s = 6;
                    } else if (value.isError()) {
                        return value;
                    }
                }
                if (s != 6) continue;
                while (!input.isEmpty() && ReconParser.isSpace(input.head())) {
                    input.step();
                }
                if (input.isEmpty() || input.head() != 64) break;
                s = 1;
            }
            return BlockValueParser.done((Object)builder.result());
        }
    }

    protected class AttrParser
    extends Parser {
        protected final Iteratee<Object> ident;
        protected final Iteratee<Object> value;
        protected final int s;

        protected AttrParser(Iteratee<Object> ident, Iteratee<Object> value, int s) {
            this.ident = ident;
            this.value = value;
            this.s = s;
        }

        protected AttrParser() {
            this(null, null, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Iteratee<Object> feed(Input input) {
            Iteratee ident;
            int c = 0;
            int s = this.s;
            Iteratee value = this.value != null ? this.value : ReconParser.this.blockParser;
            Object object = ident = this.ident != null ? this.ident : ReconParser.this.identParser;
            if (s == 1) {
                if (!input.isEmpty()) {
                    c = input.head();
                    if (c != 64) return AttrParser.expected(input, 64, c);
                    input.step();
                    s = 2;
                } else if (input.isDone()) {
                    return AttrParser.unexpectedEOF();
                }
            }
            if (s == 2) {
                if ((ident = ident.feed(input)).isDone()) {
                    s = 3;
                } else if (ident.isError()) {
                    return ident;
                }
            }
            if (s == 3) {
                if (!input.isEmpty() && input.head() == 40) {
                    input.step();
                    s = 4;
                } else if (!input.isEmpty() || input.isDone()) {
                    return AttrParser.done((Object)ReconParser.this.attr(ident.bind()));
                }
            }
            if (s == 4) {
                while (!input.isEmpty() && ReconParser.isWhitespace(c = input.head())) {
                    input.step();
                }
                if (!input.isEmpty()) {
                    if (c == 41) {
                        input.step();
                        return AttrParser.done((Object)ReconParser.this.attr(ident.bind()));
                    }
                    s = 5;
                } else if (input.isDone()) {
                    return AttrParser.unexpectedEOF();
                }
            }
            if (s == 5) {
                while ((!input.isEmpty() || input.isDone()) && value.isCont()) {
                    value = value.feed(input);
                }
                if (value.isDone()) {
                    s = 6;
                } else if (value.isError()) {
                    return value;
                }
            }
            if (s != 6) return new AttrParser((Iteratee<Object>)ident, (Iteratee<Object>)value, s);
            while (!input.isEmpty() && ReconParser.isWhitespace(c = input.head())) {
                input.step();
            }
            if (!input.isEmpty()) {
                if (c != 41) return AttrParser.expected(input, 41, c);
                input.step();
                return AttrParser.done((Object)ReconParser.this.attr(ident.bind(), value.bind()));
            }
            if (!input.isDone()) return new AttrParser((Iteratee<Object>)ident, (Iteratee<Object>)value, s);
            return AttrParser.unexpectedEOF();
        }
    }

    protected class BlockParser
    extends Parser {
        protected final ReconFactory.ItemBuilder builder;
        protected final Iteratee<Object> key;
        protected final Iteratee<Object> value;
        protected final int s;

        protected BlockParser(ReconFactory.ItemBuilder builder, Iteratee<Object> key, Iteratee<Object> value, int s) {
            this.builder = builder;
            this.key = key;
            this.value = value;
            this.s = s;
        }

        protected BlockParser() {
            this(null, null, null, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Iteratee<Object> feed(Input input) {
            ReconFactory.ItemBuilder builder;
            int c = 0;
            int s = this.s;
            Iteratee value = this.value;
            Iteratee key = this.key;
            ReconFactory.ItemBuilder itemBuilder = builder = this.builder != null ? this.builder : ReconParser.this.valueBuilder();
            while (!input.isEmpty() || input.isDone()) {
                if (s == 1) {
                    while (!input.isEmpty() && ReconParser.isWhitespace(c = input.head())) {
                        input.step();
                    }
                    if (!input.isEmpty()) {
                        if (c != 64 && c != 123 && c != 91 && !ReconParser.isNameStartChar(c) && c != 34 && c != 45 && (c < 48 || c > 57) && c != 37) return BlockParser.expected(input, "block value", c);
                        s = 2;
                    } else if (input.isDone()) {
                        return BlockParser.done((Object)builder.result());
                    }
                }
                if (s == 2) {
                    if (key == null) {
                        key = ReconParser.this.blockValueParser;
                    }
                    while ((!input.isEmpty() || input.isDone()) && key.isCont()) {
                        key = key.feed(input);
                    }
                    if (key.isDone()) {
                        s = 3;
                    } else if (key.isError()) {
                        return key;
                    }
                }
                if (s == 3) {
                    while (!input.isEmpty() && ReconParser.isSpace(c = input.head())) {
                        input.step();
                    }
                    if (!input.isEmpty()) {
                        if (c == 58) {
                            input.step();
                            s = 4;
                        } else {
                            builder.appendValue(key.bind());
                            key = null;
                            s = 6;
                        }
                    } else if (input.isDone()) {
                        builder.appendValue(key.bind());
                        return BlockParser.done((Object)builder.result());
                    }
                }
                if (s == 4) {
                    while (!input.isEmpty() && ReconParser.isSpace(input.head())) {
                        input.step();
                    }
                    if (!input.isEmpty()) {
                        s = 5;
                    } else if (input.isDone()) {
                        builder.appendField(ReconParser.this.slot(key.bind()));
                        return BlockParser.done((Object)builder.result());
                    }
                }
                if (s == 5) {
                    if (value == null) {
                        value = ReconParser.this.blockValueParser;
                    }
                    while ((!input.isEmpty() || input.isDone()) && value.isCont()) {
                        value = value.feed(input);
                    }
                    if (value.isDone()) {
                        builder.appendField(ReconParser.this.slot(key.bind(), value.bind()));
                        key = null;
                        value = null;
                        s = 6;
                    } else if (value.isError()) {
                        return value;
                    }
                }
                if (s != 6) continue;
                while (!input.isEmpty() && ReconParser.isSpace(c = input.head())) {
                    input.step();
                }
                if (!input.isEmpty()) {
                    if (c != 44 && c != 59 && !ReconParser.isNewline(c)) return BlockParser.done((Object)builder.result());
                    input.step();
                    s = 1;
                    continue;
                }
                if (!input.isDone()) continue;
                return BlockParser.done((Object)builder.result());
            }
            return new BlockParser(builder, key, value, s);
        }
    }

    protected class DocumentParser
    extends Parser {
        protected final Iteratee<Object> value;

        protected DocumentParser(Iteratee<Object> value) {
            this.value = value;
        }

        protected DocumentParser() {
            this(null);
        }

        public Iteratee<Object> feed(Input input) {
            Iteratee value;
            Object object = value = this.value != null ? this.value : ReconParser.this.blockParser;
            while ((!input.isEmpty() || input.isDone()) && value.isCont()) {
                value = value.feed(input);
            }
            if (value.isDone()) {
                if (!input.isEmpty()) {
                    return DocumentParser.unexpected(input, input.head());
                }
                if (input.isDone()) {
                    return value;
                }
            } else if (value.isError()) {
                return value;
            }
            return new DocumentParser((Iteratee<Object>)value);
        }
    }

    protected static abstract class Parser
    extends Iteratee<Object> {
        protected Parser() {
        }

        public Object parse(String string) {
            Input input = Input.from((String)string);
            Iteratee<Object> output = this.run(input);
            if (!input.isEmpty()) {
                output = Parser.unexpected(input, input.head());
            }
            if (output.isDone()) {
                return output.bind();
            }
            Throwable trap = output.trap();
            if (trap instanceof RuntimeException) {
                throw (RuntimeException)trap;
            }
            return null;
        }

        protected static Iteratee<Object> unexpectedEOF() {
            ReconException cause = new ReconException("unexpected end of input", Input.DONE);
            return Parser.error((Throwable)cause);
        }

        protected static Iteratee<Object> unexpected(Input input, int found) {
            StringBuilder message = new StringBuilder().append("unexpected ").append('\'').appendCodePoint(found).append('\'');
            ReconException cause = new ReconException(message.toString(), input);
            return Parser.error((Throwable)cause);
        }

        protected static Iteratee<Object> expected(Input input, int expected) {
            StringBuilder message = new StringBuilder().append("expected ").append('\'').appendCodePoint(expected).append('\'');
            ReconException cause = new ReconException(message.toString(), input);
            return Parser.error((Throwable)cause);
        }

        protected static Iteratee<Object> expected(Input input, String expected) {
            StringBuilder message = new StringBuilder().append("expected ").append(expected);
            ReconException cause = new ReconException(message.toString(), input);
            return Parser.error((Throwable)cause);
        }

        protected static Iteratee<Object> expected(Input input, int expected, int found) {
            StringBuilder message = new StringBuilder().append("expected ").append('\'').appendCodePoint(expected).append('\'').append(", but found ").append('\'').appendCodePoint(found).append('\'');
            ReconException cause = new ReconException(message.toString(), input);
            return Parser.error((Throwable)cause);
        }

        protected static Iteratee<Object> expected(Input input, String expected, int found) {
            StringBuilder message = new StringBuilder().append("expected ").append(expected).append(", but found ").append('\'').appendCodePoint(found).append('\'');
            ReconException cause = new ReconException(message.toString(), input);
            return Parser.error((Throwable)cause);
        }
    }
}

