/*
 * Decompiled with CFR 0.152.
 */
package it.swim.recon;

import it.swim.recon.Attr;
import it.swim.recon.Extant;
import it.swim.recon.ReconFactory;
import it.swim.recon.ReconParser;
import it.swim.recon.ReconStringWriter;
import it.swim.recon.Record;
import it.swim.recon.Slot;
import it.swim.util.HashGenCacheSet;
import java.nio.ByteBuffer;
import java.util.Comparator;

public class Recon
extends ReconParser
implements Comparator<Object> {
    public static final Extant EXTANT;
    public static final Object ABSENT;
    static final HashGenCacheSet<String> stringCache;

    static Object cache(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (string.length() <= 128) {
                return stringCache.put((Object)string);
            }
            return string;
        }
        return value;
    }

    public Object parseRecon(String string) {
        return this.blockParser.parse(string);
    }

    public Record parseReconRecord(String string) {
        Object value = this.blockParser.parse(string);
        if (value instanceof Record) {
            return (Record)value;
        }
        return Record.of(new Object[]{value});
    }

    public String writeRecon(Object value) {
        ReconStringWriter writer = new ReconStringWriter();
        writer.writeValue(value);
        return writer.toString();
    }

    public String writeReconBlock(Object value) {
        ReconStringWriter writer = new ReconStringWriter();
        writer.writeBlock(value);
        return writer.toString();
    }

    @Override
    public Attr attr(Object key, Object value) {
        return new Attr((String)Recon.cache(key), Recon.cache(value));
    }

    @Override
    public Attr attr(Object key) {
        return new Attr((String)Recon.cache(key));
    }

    @Override
    public Slot slot(Object key, Object value) {
        return new Slot(Recon.cache(key), Recon.cache(value));
    }

    @Override
    public Slot slot(Object key) {
        return new Slot(Recon.cache(key));
    }

    @Override
    public ReconFactory.ItemBuilder valueBuilder() {
        return new ValueBuilder();
    }

    @Override
    public ReconFactory.ItemBuilder recordBuilder() {
        return new RecordBuilder();
    }

    @Override
    public ReconFactory.TextBuilder textBuilder() {
        return new TextBuilder();
    }

    @Override
    public ReconFactory.DataBuilder dataBuilder() {
        return new DataBuilder();
    }

    public ByteBuffer base64(String data) {
        DataBuilder builder = new DataBuilder();
        int n = data.length();
        int index = 0;
        while (index < n) {
            builder.appendCodePoint(data.codePointAt(index));
            index = data.offsetByCodePoints(index, 1);
        }
        return builder.result();
    }

    @Override
    public Number number(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e1) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e2) {
                return Double.parseDouble(value);
            }
        }
    }

    @Override
    public Extant extant() {
        return EXTANT;
    }

    @Override
    public Object absent() {
        return null;
    }

    @Override
    public int compare(Object x, Object y) {
        return Recon.compareObject(x, y);
    }

    static int compareObject(Object x, Object y) {
        if (x != null && x.equals(true)) {
            x = "true";
        } else if (x != null && x.equals(false)) {
            x = "false";
        }
        if (y != null && y.equals(true)) {
            y = "true";
        } else if (y != null && y.equals(false)) {
            y = "false";
        }
        if (x == null) {
            if (y == null) {
                return 0;
            }
            return 1;
        }
        if (x instanceof Extant) {
            if (y == null) {
                return -1;
            }
            if (y instanceof Extant) {
                return 0;
            }
            return 1;
        }
        if (x instanceof Number) {
            if (y == null || y instanceof Extant) {
                return -1;
            }
            if (y instanceof Number) {
                return Recon.compareNumber((Number)x, (Number)y);
            }
            return 1;
        }
        if (x instanceof String) {
            if (y == null || y instanceof Extant || y instanceof Number) {
                return -1;
            }
            if (y instanceof String) {
                return Recon.compareString((String)x, (String)y);
            }
            return 1;
        }
        if (x instanceof ByteBuffer) {
            if (y == null || y instanceof Extant || y instanceof Number || y instanceof String) {
                return -1;
            }
            if (y instanceof ByteBuffer) {
                return Recon.compareData((ByteBuffer)x, (ByteBuffer)y);
            }
            return 1;
        }
        if (x instanceof Record) {
            if (y == null || y instanceof Extant || y instanceof Number || y instanceof String || y instanceof ByteBuffer) {
                return -1;
            }
            if (y instanceof Record) {
                return Recon.compareRecord((Record)x, (Record)y);
            }
            return 1;
        }
        if (x instanceof Slot) {
            if (y == null || y instanceof Extant || y instanceof Number || y instanceof String || y instanceof ByteBuffer || y instanceof Record) {
                return -1;
            }
            if (y instanceof Slot) {
                return Recon.compareSlot((Slot)x, (Slot)y);
            }
            return 1;
        }
        if (x instanceof Attr) {
            if (y == null || y instanceof Extant || y instanceof Number || y instanceof String || y instanceof ByteBuffer || y instanceof Record || y instanceof Slot) {
                return -1;
            }
            if (y instanceof Attr) {
                return Recon.compareAttr((Attr)x, (Attr)y);
            }
            return 1;
        }
        if (y == null || y instanceof Extant || y instanceof Number || y instanceof String || y instanceof ByteBuffer || y instanceof Record || y instanceof Slot || y instanceof Attr) {
            return -1;
        }
        return 0;
    }

    static int compareAttr(Attr x, Attr y) {
        return x.compareTo(y);
    }

    static int compareSlot(Slot x, Slot y) {
        return x.compareTo(y);
    }

    static int compareRecord(Record x, Record y) {
        return x.compareTo(y);
    }

    static int compareData(ByteBuffer x, ByteBuffer y) {
        return x.compareTo(y);
    }

    static int compareString(String x, String y) {
        return x.compareTo(y);
    }

    static int compareNumber(Number x, Number y) {
        if (x instanceof Double || y instanceof Double) {
            return Double.compare(x.doubleValue(), y.doubleValue());
        }
        if (x instanceof Float || y instanceof Float) {
            return Float.compare(x.floatValue(), y.floatValue());
        }
        if (x instanceof Long || y instanceof Long) {
            return Long.compare(x.longValue(), y.longValue());
        }
        if (x instanceof Integer || y instanceof Integer) {
            return Integer.compare(x.intValue(), y.intValue());
        }
        return Double.compare(x.doubleValue(), y.doubleValue());
    }

    static {
        int stringCacheSize;
        EXTANT = new Extant();
        ABSENT = null;
        try {
            stringCacheSize = Integer.parseInt(System.getProperty("swim.recon.string.cache.size"));
        }
        catch (Exception e) {
            stringCacheSize = 64;
        }
        stringCache = new HashGenCacheSet(stringCacheSize);
    }

    static final class DataBuilder
    extends ReconFactory.DataBuilder {
        private byte[] buffer = new byte[32];
        private int size = 0;

        DataBuilder() {
        }

        private static int expand(int n) {
            n = Math.max(32, n) - 1;
            n |= n >> 1;
            n |= n >> 2;
            n |= n >> 4;
            n |= n >> 8;
            n |= n >> 16;
            return n + 1;
        }

        @Override
        public void appendByte(byte value) {
            byte[] buffer = this.buffer;
            if (buffer == null || this.size + 1 > buffer.length) {
                buffer = new byte[DataBuilder.expand(this.size + 1)];
                if (this.buffer != null) {
                    System.arraycopy(this.buffer, 0, buffer, 0, this.size);
                }
                this.buffer = buffer;
            }
            buffer[this.size] = value;
            ++this.size;
        }

        @Override
        public ByteBuffer result() {
            return ByteBuffer.wrap(this.buffer, 0, this.size);
        }
    }

    static final class TextBuilder
    extends ReconFactory.TextBuilder {
        private StringBuilder builder = new StringBuilder();

        TextBuilder() {
        }

        @Override
        public void appendCodePoint(int codePoint) {
            this.builder.appendCodePoint(codePoint);
        }

        @Override
        public Object result() {
            String value = this.builder.toString();
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
            return Recon.cache(value);
        }
    }

    static final class RecordBuilder
    extends ReconFactory.ItemBuilder {
        private Record record = new Record();

        RecordBuilder() {
        }

        @Override
        public void appendField(Object field) {
            this.record.add(field);
        }

        @Override
        public void appendValue(Object value) {
            this.record.add(value);
        }

        @Override
        public Record result() {
            return this.record;
        }
    }

    static final class ValueBuilder
    extends ReconFactory.ItemBuilder {
        private Record record = null;
        private Object value = null;

        ValueBuilder() {
        }

        @Override
        public void appendField(Object item) {
            if (this.record != null) {
                this.record.add(item);
            } else {
                this.record = new Record();
                if (this.value != null) {
                    this.record.add(this.value);
                    this.value = null;
                }
                this.record.add(item);
            }
        }

        @Override
        public void appendValue(Object item) {
            if (this.record != null) {
                this.record.add(item);
            } else if (this.value == null) {
                this.value = item;
            } else {
                this.record = new Record();
                this.record.add(this.value);
                this.value = null;
                this.record.add(item);
            }
        }

        @Override
        public Object result() {
            if (this.record != null) {
                return this.record;
            }
            return this.value;
        }
    }
}

