/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.colyseus.Connection;
import io.colyseus.Room;
import io.colyseus.serializer.schema.Schema;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class Client {
    private String id;
    private LinkedHashMap<String, String> httpHeaders;
    private int connectTimeout;
    private Connection connection;
    public LinkedHashMap<String, Room> rooms = new LinkedHashMap();
    public LinkedHashMap<Integer, Room> connectingRooms = new LinkedHashMap();
    private int requestId = 0;
    private String hostname;
    private Listener listener;
    private ObjectMapper msgpackMapper;
    private ObjectMapper defaultMapper;
    int previousCode;

    public Client(String url) {
        this(url, null, null, null, 0, null);
    }

    public Client(String url, Listener listener) {
        this(url, null, null, null, 0, listener);
    }

    public Client(String url, String id) {
        this(url, id, null, null, 0, null);
    }

    public Client(String url, String id, Listener listener) {
        this(url, id, null, null, 0, listener);
    }

    public Client(String url, String id, LinkedHashMap<String, Object> options, LinkedHashMap<String, String> httpHeaders, int connectTimeout, Listener listener) {
        this.hostname = url;
        this.id = id;
        this.httpHeaders = httpHeaders == null ? new LinkedHashMap() : httpHeaders;
        this.connectTimeout = connectTimeout;
        this.listener = listener;
        this.defaultMapper = new ObjectMapper();
        this.msgpackMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        this.connect(options == null ? new LinkedHashMap<String, Object>() : options, connectTimeout);
    }

    public String getId() {
        return this.id;
    }

    public Room join(String roomName, Class<? extends Schema> type) {
        return this.createRoomRequest(type, roomName, null);
    }

    public Room join(String roomName, LinkedHashMap<String, Object> options, Class<? extends Schema> type) {
        return this.createRoomRequest(type, roomName, options);
    }

    public Room rejoin(String roomName, String sessionId, Class<? extends Schema> type) {
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        options.put("sessionId", sessionId);
        return this.join(roomName, options, type);
    }

    private Room createRoomRequest(Class<?> type, String roomName, LinkedHashMap<String, Object> options) {
        if (options == null) {
            options = new LinkedHashMap();
        }
        options.put("requestId", ++this.requestId);
        Room room = this.createRoom(type, roomName, options);
        this.connectingRooms.put((int)((Integer)options.get("requestId")), room);
        this.connection.send(9, roomName, options);
        return room;
    }

    private Room createRoom(Class<?> type, String roomName, LinkedHashMap<String, Object> options) {
        return new Room(type, this, roomName, options);
    }

    public void close() {
        this.connection.close();
    }

    private void connect(LinkedHashMap<String, Object> options, int connectTimeout) {
        URI uri;
        try {
            uri = new URI(this.buildEndpoint("", options));
        }
        catch (JsonProcessingException | UnsupportedEncodingException | URISyntaxException e) {
            if (this.listener != null) {
                this.listener.onError((Exception)e);
            }
            return;
        }
        this.connection = new Connection(uri, connectTimeout, this.httpHeaders, new Connection.Listener(){

            @Override
            public void onError(Exception e) {
                if (Client.this.listener != null) {
                    Client.this.listener.onError(e);
                }
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                if (Client.this.listener != null) {
                    Client.this.listener.onClose(code, reason, remote);
                }
            }

            @Override
            public void onOpen() {
                if (Client.this.id != null && Client.this.listener != null) {
                    Client.this.listener.onOpen(Client.this.id);
                }
            }

            @Override
            public void onMessage(ByteBuffer bytes) {
                Client.this.onMessageCallback(bytes);
            }
        });
    }

    private String buildEndpoint(String path, LinkedHashMap<String, Object> options) throws UnsupportedEncodingException, JsonProcessingException {
        String charset = "UTF-8";
        StringBuilder sb = new StringBuilder();
        for (String name : options.keySet()) {
            sb.append("&");
            sb.append(URLEncoder.encode(name, charset));
            sb.append("=");
            sb.append(URLEncoder.encode(this.defaultMapper.writeValueAsString(options.get(name)), charset));
        }
        return this.hostname + "/" + path + "?colyseusid=" + URLEncoder.encode(this.id == null ? "" : this.id, charset) + sb.toString();
    }

    private void onMessageCallback(ByteBuffer buf) {
        block15: {
            try {
                if (this.previousCode == 0) {
                    byte code = buf.get();
                    if (code == 1) {
                        byte[] bytes = new byte[buf.get()];
                        buf.get(bytes);
                        this.id = new String(bytes, StandardCharsets.UTF_8);
                        System.out.println("colyseus id : " + this.id);
                        if (this.listener != null) {
                            this.listener.onOpen(this.id);
                        }
                    } else if (code == 9) {
                        byte requestId = buf.get();
                        Room room = this.connectingRooms.get(requestId);
                        if (room == null) {
                            System.out.println("client left room before receiving session id.");
                            return;
                        }
                        byte[] bytes = new byte[buf.get()];
                        buf.get(bytes, 0, bytes.length);
                        room.setId(new String(bytes, StandardCharsets.UTF_8));
                        String processPath = "";
                        if (buf.hasRemaining()) {
                            bytes = new byte[buf.get()];
                            buf.get(bytes, 0, bytes.length);
                            processPath = new String(bytes, StandardCharsets.UTF_8);
                        }
                        this.connectingRooms.remove(requestId);
                        this.rooms.put(room.getId(), room);
                        room.connect(this.buildEndpoint(processPath + "/" + room.getId(), room.getOptions()), this.httpHeaders, this.connectTimeout);
                    } else if (code == 11) {
                        byte length = buf.get();
                        byte[] bytes = new byte[length];
                        buf.get(bytes);
                        String message = new String(bytes, StandardCharsets.UTF_8);
                        if (this.listener != null) {
                            this.listener.onError(new Exception(message));
                        }
                    } else if (code == 20) {
                        this.previousCode = code;
                    }
                } else {
                    this.previousCode = 0;
                }
            }
            catch (Exception e) {
                if (this.listener == null) break block15;
                this.listener.onError(e);
            }
        }
    }

    private void dispatchOnMessage(byte[] bytes) throws IOException {
        if (this.listener != null) {
            this.listener.onMessage(this.msgpackMapper.readValue(bytes, (TypeReference)new TypeReference<Object>(){}));
        }
    }

    void onRoomLeave(String roomId) {
        this.rooms.remove(roomId);
    }

    public static interface Listener {
        public void onOpen(String var1);

        public void onMessage(Object var1);

        public void onClose(int var1, String var2, boolean var3);

        public void onError(Exception var1);
    }
}

