/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.colyseus.Connection;
import io.colyseus.Room;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;

public class Client {
    private String id;
    private LinkedHashMap<String, String> httpHeaders;
    private int connectTimeout;
    private Connection connection;
    public LinkedHashMap<String, Room> rooms = new LinkedHashMap();
    public LinkedHashMap<Integer, Room> connectingRooms = new LinkedHashMap();
    private int requestId = 0;
    private String hostname;
    private LinkedHashMap<Integer, AvailableRoomsRequestListener> availableRoomsRequests = new LinkedHashMap();
    private Listener listener;
    private ObjectMapper msgpackMapper;
    private ObjectMapper defaultMapper;

    public Client(String url) {
        this(url, null, null, null, 0, null);
    }

    public Client(String url, Listener listener) {
        this(url, null, null, null, 0, listener);
    }

    public Client(String url, String id) {
        this(url, id, null, null, 0, null);
    }

    public Client(String url, String id, Listener listener) {
        this(url, id, null, null, 0, listener);
    }

    public Client(String url, String id, LinkedHashMap<String, Object> options, LinkedHashMap<String, String> httpHeaders, int connectTimeout, Listener listener) {
        this.hostname = url;
        this.id = id;
        this.httpHeaders = httpHeaders == null ? new LinkedHashMap() : httpHeaders;
        this.connectTimeout = connectTimeout;
        this.listener = listener;
        this.defaultMapper = new ObjectMapper();
        this.msgpackMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        this.connect(options == null ? new LinkedHashMap<String, Object>() : options, connectTimeout);
    }

    public String getId() {
        return this.id;
    }

    public Room join(String roomName) {
        return this.createRoomRequest(roomName, null);
    }

    public Room join(String roomName, LinkedHashMap<String, Object> options) {
        return this.createRoomRequest(roomName, options);
    }

    public Room rejoin(String roomName, String sessionId) {
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        options.put("sessionId", sessionId);
        return this.join(roomName, options);
    }

    private Room createRoomRequest(String roomName, LinkedHashMap<String, Object> options) {
        if (options == null) {
            options = new LinkedHashMap();
        }
        options.put("requestId", ++this.requestId);
        final Room room = this.createRoom(roomName, options);
        final LinkedHashMap<String, Object> finalOptions = options;
        room.addListener(new Room.Listener(){

            @Override
            public void onLeave() {
                Client.this.rooms.remove(room.getId());
                Client.this.connectingRooms.remove(finalOptions.get("requestId"));
            }
        });
        this.connectingRooms.put((int)((Integer)options.get("requestId")), room);
        this.connection.send(10, roomName, options);
        return room;
    }

    private Room createRoom(String roomName, LinkedHashMap<String, Object> options) {
        return new Room(roomName, options);
    }

    public void getAvailableRooms(String roomName, final GetAvailableRoomsCallback callback) {
        ++this.requestId;
        final int requestIdFinal = this.requestId;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                    if (Client.this.availableRoomsRequests.containsKey(requestIdFinal)) {
                        Client.this.availableRoomsRequests.remove(requestIdFinal);
                        callback.onCallback(null, "timeout");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.connection.send(20, requestIdFinal, roomName);
        this.availableRoomsRequests.put(requestIdFinal, new AvailableRoomsRequestListener(){

            @Override
            public void callback(List<AvailableRoom> availableRooms) {
                Client.this.availableRoomsRequests.remove(requestIdFinal);
                callback.onCallback(availableRooms, null);
            }
        });
    }

    public void close() {
        this.connection.close();
    }

    private void connect(LinkedHashMap<String, Object> options, int connectTimeout) {
        URI uri;
        try {
            uri = new URI(this.buildEndpoint("", options));
        }
        catch (JsonProcessingException | UnsupportedEncodingException | URISyntaxException e) {
            if (this.listener != null) {
                this.listener.onError((Exception)e);
            }
            return;
        }
        this.connection = new Connection(uri, connectTimeout, this.httpHeaders, new Connection.Listener(){

            @Override
            public void onError(Exception e) {
                if (Client.this.listener != null) {
                    Client.this.listener.onError(e);
                }
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                if (Client.this.listener != null) {
                    Client.this.listener.onClose(code, reason, remote);
                }
            }

            @Override
            public void onOpen() {
                if (Client.this.id != null && Client.this.listener != null) {
                    Client.this.listener.onOpen(Client.this.id);
                }
            }

            @Override
            public void onMessage(byte[] bytes) {
                Client.this.onMessageCallback(bytes);
            }
        });
    }

    private String buildEndpoint(String path, LinkedHashMap<String, Object> options) throws UnsupportedEncodingException, JsonProcessingException {
        String charset = "UTF-8";
        try {
            charset = StandardCharsets.UTF_8.name();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        for (String name : options.keySet()) {
            sb.append("&");
            sb.append(URLEncoder.encode(name, charset));
            sb.append("=");
            sb.append(URLEncoder.encode(this.defaultMapper.writeValueAsString(options.get(name)), charset));
        }
        return this.hostname + "/" + path + "?colyseusid=" + URLEncoder.encode(this.id == null ? "" : this.id, charset) + sb.toString();
    }

    private void onMessageCallback(byte[] bytes) {
        block28: {
            try {
                MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);
                ImmutableValue val = unpacker.unpackValue();
                if (val.getValueType() == ValueType.ARRAY) {
                    ArrayValue arrayValue = val.asArrayValue();
                    Value codeValue = arrayValue.get(0);
                    if (codeValue.getValueType() == ValueType.INTEGER) {
                        int code = codeValue.asIntegerValue().asInt();
                        switch (code) {
                            case 1: {
                                this.id = arrayValue.get(1).asStringValue().asString();
                                if (this.listener != null) {
                                    this.listener.onOpen(this.id);
                                    break;
                                }
                                break block28;
                            }
                            case 10: {
                                int requestId = arrayValue.get(2).asIntegerValue().asInt();
                                Room room = this.connectingRooms.get(requestId);
                                if (room == null) {
                                    System.out.println("client left room before receiving session id.");
                                    return;
                                }
                                room.setId(arrayValue.get(1).asStringValue().asString());
                                this.rooms.put(room.getId(), room);
                                room.connect(this.buildEndpoint(room.getId(), room.getOptions()), this.httpHeaders, this.connectTimeout);
                                this.connectingRooms.remove(requestId);
                                break;
                            }
                            case 11: {
                                System.err.println("colyseus: server error: " + arrayValue.get(2).toString());
                                if (this.listener != null) {
                                    this.listener.onError(new Exception(arrayValue.get(2).toString()));
                                    break;
                                }
                                break block28;
                            }
                            case 20: {
                                int id = arrayValue.get(1).asIntegerValue().asInt();
                                ArrayValue roomsArrayValue = arrayValue.get(2).asArrayValue();
                                ArrayList<AvailableRoom> availableRooms = new ArrayList<AvailableRoom>();
                                for (int i = 0; i < roomsArrayValue.size(); ++i) {
                                    MapValue roomMapValue = roomsArrayValue.get(i).asMapValue();
                                    AvailableRoom room = new AvailableRoom();
                                    for (Map.Entry entry : roomMapValue.entrySet()) {
                                        switch (((Value)entry.getKey()).asStringValue().asString()) {
                                            case "clients": {
                                                room.clients = ((Value)entry.getValue()).asIntegerValue().asInt();
                                                break;
                                            }
                                            case "maxClients": {
                                                room.maxClients = ((Value)entry.getValue()).asIntegerValue().asInt();
                                                break;
                                            }
                                            case "roomId": {
                                                room.roomId = ((Value)entry.getValue()).asStringValue().asString();
                                                break;
                                            }
                                            case "metadata": {
                                                room.metadata = (Value)entry.getValue();
                                            }
                                        }
                                    }
                                    availableRooms.add(room);
                                }
                                if (this.availableRoomsRequests.containsKey(id)) {
                                    this.availableRoomsRequests.get(id).callback(availableRooms);
                                    break;
                                }
                                System.out.println("receiving ROOM_LIST after timeout:" + roomsArrayValue);
                                break;
                            }
                            default: {
                                this.dispatchOnMessage(bytes);
                            }
                        }
                        break block28;
                    }
                    this.dispatchOnMessage(bytes);
                    break block28;
                }
                this.dispatchOnMessage(bytes);
            }
            catch (Exception e) {
                if (this.listener == null) break block28;
                this.listener.onError(e);
            }
        }
    }

    private void dispatchOnMessage(byte[] bytes) throws IOException {
        if (this.listener != null) {
            this.listener.onMessage(this.msgpackMapper.readValue(bytes, (TypeReference)new TypeReference<Object>(){}));
        }
    }

    public static class AvailableRoom {
        public int clients;
        public int maxClients;
        public String roomId;
        public Value metadata;

        public String toString() {
            return "{clients:" + this.clients + ", maxClients:" + this.maxClients + ", roomId:" + this.roomId + ", metadata:" + this.metadata + ", }";
        }
    }

    public static interface AvailableRoomsRequestListener {
        public void callback(List<AvailableRoom> var1);
    }

    public static interface GetAvailableRoomsCallback {
        public void onCallback(List<AvailableRoom> var1, String var2);
    }

    public static interface Listener {
        public void onOpen(String var1);

        public void onMessage(Object var1);

        public void onClose(int var1, String var2, boolean var3);

        public void onError(Exception var1);
    }
}

