package io.colyseus;

import java.util.LinkedHashMap;

public abstract class RoomListener {

    boolean once = false;

    protected RoomListener() {

    }

    protected RoomListener(boolean once) {
        this.once = once;
    }

    protected void onLeave() {

    }

    protected void onError(Exception e) {

    }

    protected void onMessage(Object message) {

    }

    protected void onJoin() {

    }

    protected void onStateChange(LinkedHashMap<String, Object> state) {

    }
}
