/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus.state_listener;

import io.colyseus.state_listener.PatchObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class Compare {
    private static final Set<Class<?>> WRAPPER_TYPES = Compare.getWrapperTypes();

    public static List<PatchObject> compare(LinkedHashMap<String, Object> tree1, LinkedHashMap<String, Object> tree2) {
        ArrayList<PatchObject> patches = new ArrayList<PatchObject>();
        Compare.generate(tree1, tree2, patches, new ArrayList<String>());
        return patches;
    }

    public static void generate(List<Object> mirror, List<Object> obj, List<PatchObject> patches, List<String> path) {
        LinkedHashMap<String, Object> mirrorDict = new LinkedHashMap<String, Object>();
        for (int i = 0; i < mirror.size(); ++i) {
            mirrorDict.put(String.valueOf(i), mirror.get(i));
        }
        LinkedHashMap<String, Object> objDict = new LinkedHashMap<String, Object>();
        for (int i = 0; i < obj.size(); ++i) {
            objDict.put(String.valueOf(i), obj.get(i));
        }
        Compare.generate(mirrorDict, objDict, patches, path);
    }

    public static void generate(LinkedHashMap<String, Object> mirror, LinkedHashMap<String, Object> obj, List<PatchObject> patches, List<String> path) {
        Object newVal;
        Set<String> newKeys = obj.keySet();
        Set<String> oldKeys = mirror.keySet();
        boolean deleted = false;
        for (String key : oldKeys) {
            if (obj.containsKey(key) && obj.get(key) != null && (obj.containsKey(key) || !mirror.containsKey(key) || obj instanceof List)) {
                Object oldVal = mirror.get(key);
                newVal = obj.get(key);
                if (!(oldVal == null || newVal == null || Compare.isPrimitive(oldVal.getClass()) || oldVal instanceof String || Compare.isPrimitive(newVal.getClass()) || newVal instanceof String || !oldVal.getClass().equals(newVal.getClass()))) {
                    ArrayList<String> deeperPath = new ArrayList<String>(path);
                    deeperPath.add(key);
                    if (oldVal instanceof LinkedHashMap) {
                        Compare.generate((LinkedHashMap)oldVal, (LinkedHashMap)newVal, patches, deeperPath);
                        continue;
                    }
                    if (!(oldVal instanceof List)) continue;
                    Compare.generate((List)oldVal, (List)newVal, patches, deeperPath);
                    continue;
                }
                if ((oldVal != null || newVal == null) && oldVal.equals(newVal)) continue;
                ArrayList<String> replacePath = new ArrayList<String>(path);
                replacePath.add(key);
                patches.add(new PatchObject("replace", replacePath, newVal));
                continue;
            }
            ArrayList<String> removePath = new ArrayList<String>(path);
            removePath.add(key);
            patches.add(new PatchObject("remove", removePath, null));
            deleted = true;
        }
        if (!deleted && newKeys.size() == oldKeys.size()) {
            return;
        }
        for (String key : newKeys) {
            if (mirror.containsKey(key) || !obj.containsKey(key)) continue;
            ArrayList<String> addPath = new ArrayList<String>(path);
            addPath.add(key);
            newVal = obj.get(key);
            if (newVal != null && !Compare.isPrimitive(newVal.getClass()) && !(newVal instanceof String)) {
                if (newVal instanceof LinkedHashMap) {
                    Compare.generate(new LinkedHashMap<String, Object>(), (LinkedHashMap)newVal, patches, addPath);
                } else if (newVal instanceof List) {
                    Compare.generate(new ArrayList<Object>(), (List)newVal, patches, addPath);
                }
            }
            patches.add(new PatchObject("add", addPath, newVal));
        }
    }

    private static boolean isPrimitive(Class<?> clazz) {
        return WRAPPER_TYPES.contains(clazz);
    }

    private static Set<Class<?>> getWrapperTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        return ret;
    }
}

