/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.colyseus.Connection;
import io.colyseus.Room;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;

public class Client {
    private String id;
    private Map<String, String> httpHeaders;
    private Connection connection;
    private LinkedHashMap<String, Room> rooms = new LinkedHashMap();
    private LinkedHashMap<Integer, Room> connectingRooms = new LinkedHashMap();
    private int requestId = 0;
    private String hostname;
    private LinkedHashMap<Integer, AvailableRoomsRequestListener> roomsAvailableRequests = new LinkedHashMap();
    private Listener listener;
    private ObjectMapper objectMapper;

    public Client(String url, Listener listener) throws URISyntaxException {
        this(url, null, null, listener);
    }

    public Client(String url, Map<String, String> httpHeaders, Listener listener) throws URISyntaxException {
        this(url, null, httpHeaders, listener);
    }

    public Client(String url, LinkedHashMap<String, Object> options, Listener listener) throws URISyntaxException {
        this(url, options, null, listener);
    }

    public Client(String url, LinkedHashMap<String, Object> options, Map<String, String> httpHeaders, Listener listener) throws URISyntaxException {
        this.hostname = url;
        this.httpHeaders = httpHeaders == null ? new LinkedHashMap() : httpHeaders;
        this.listener = listener;
        this.objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        this.connect(null, options == null ? new LinkedHashMap() : options);
    }

    public Room join(String roomName) {
        return this.createRoomRequest(roomName, null, null, 0, 0);
    }

    public Room join(String roomName, LinkedHashMap<String, Object> options) {
        return this.createRoomRequest(roomName, options, null, 0, 0);
    }

    public Room join(String roomName, LinkedHashMap<String, Object> options, int retryTimes) {
        return this.createRoomRequest(roomName, options, null, retryTimes, 0);
    }

    public Room rejoin(String roomName, String sessionId) {
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        options.put("sessionId ", sessionId);
        return this.join(roomName, options);
    }

    private Room createRoomRequest(final String roomName, LinkedHashMap<String, Object> options, Room reuseRoomInstance, final int retryTimes, final int retryCount) {
        System.out.println("createRoomRequest(" + roomName + "," + options + "," + reuseRoomInstance + "," + retryTimes + "," + retryCount);
        if (options == null) {
            options = new LinkedHashMap();
        }
        options.put("requestId", ++this.requestId);
        if (retryTimes > 0) {
            options.put("retryTimes", retryTimes);
        }
        final Room room = reuseRoomInstance == null ? this.createRoom(roomName, options) : reuseRoomInstance;
        final LinkedHashMap<String, Object> finalOptions = options;
        room.addListener(new Room.RoomListener(true){

            @Override
            public void onLeave() {
                Client.this.rooms.remove(room.getId());
                Client.this.connectingRooms.remove(finalOptions.get("requestId"));
            }
        });
        if (retryTimes > 0) {
            room.addListener(new Room.RoomListener(true){

                @Override
                public void onError(Exception e) {
                    System.out.println("////////////////////////////////////////////");
                    if (!room.hasJoined() && retryCount <= retryTimes) {
                        Client.this.createRoomRequest(roomName, finalOptions, room, retryTimes, retryCount + 1);
                    }
                }
            });
        }
        this.connectingRooms.put((int)((Integer)options.get("requestId")), room);
        this.connection.send(10, roomName, options);
        return room;
    }

    private Room createRoom(String roomName, LinkedHashMap<String, Object> options) {
        return new Room(roomName, options);
    }

    public void getAvailableRooms(String roomName, final GetAvailableRoomsCallback callback) {
        ++this.requestId;
        final int requestIdFinal = this.requestId;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                    if (Client.this.roomsAvailableRequests.containsKey(requestIdFinal)) {
                        Client.this.roomsAvailableRequests.remove(requestIdFinal);
                        callback.onCallback(null, "timeout");
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        });
        this.connection.send(20, this.requestId, roomName);
        this.roomsAvailableRequests.put(this.requestId, new AvailableRoomsRequestListener(){

            @Override
            public void callback(List<AvailableRoom> roomsAvailable) {
                Client.this.roomsAvailableRequests.remove(Client.this.requestId);
                callback.onCallback(roomsAvailable, null);
            }
        });
    }

    public void close() {
        this.connection.close();
    }

    private void connect(String colyseusid, LinkedHashMap<String, Object> options) throws URISyntaxException {
        if (colyseusid != null) {
            this.id = colyseusid;
        }
        this.connection = new Connection(this.buildEndpoint("", options), 10000, this.httpHeaders, new Connection.Listener(){

            @Override
            public void onError(Exception e) {
                if (Client.this.listener != null) {
                    Client.this.listener.onError(e);
                }
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                if (Client.this.listener != null) {
                    Client.this.listener.onClose(code, reason, remote);
                }
            }

            @Override
            public void onOpen() {
                if (Client.this.id != null && Client.this.listener != null) {
                    Client.this.listener.onOpen();
                }
            }

            @Override
            public void onMessage(byte[] bytes) {
                if (Client.this.listener != null) {
                    Client.this.onMessageCallback(bytes);
                }
            }
        });
    }

    private String buildEndpoint(String path, LinkedHashMap<String, Object> options) {
        ArrayList<String> params = new ArrayList<String>();
        for (String name : options.keySet()) {
            params.add(name + "=" + options.get(name).toString());
        }
        StringBuilder sb = new StringBuilder();
        for (String s : params) {
            sb.append("&");
            sb.append(s);
        }
        return this.hostname + "/" + path + "?colyseusid=" + (this.id == null ? "" : this.id) + sb.toString();
    }

    private void onMessageCallback(byte[] bytes) {
        block28: {
            System.out.println("Client.onMessageCallback()");
            try {
                MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])bytes);
                ImmutableValue val = unpacker.unpackValue();
                if (val.getValueType() == ValueType.ARRAY) {
                    ArrayValue arrayValue = val.asArrayValue();
                    Value codeValue = arrayValue.get(0);
                    if (codeValue.getValueType() == ValueType.INTEGER) {
                        int code = codeValue.asIntegerValue().asInt();
                        switch (code) {
                            case 1: {
                                System.out.println("Protocol: USER_ID");
                                this.id = arrayValue.get(1).asStringValue().asString();
                                System.out.println("colyseus id : " + this.id);
                                if (this.listener != null) {
                                    this.listener.onOpen();
                                    break;
                                }
                                break block28;
                            }
                            case 10: {
                                System.out.println("Protocol: JOIN_ROOM");
                                int requestId = arrayValue.get(2).asIntegerValue().asInt();
                                System.out.println("requestId: " + requestId);
                                Room room = this.connectingRooms.get(requestId);
                                if (room == null) {
                                    System.out.println("client left room before receiving session id.");
                                    return;
                                }
                                room.setId(arrayValue.get(1).asStringValue().asString());
                                System.out.println("room.id: " + room.getId());
                                this.rooms.put(room.getId(), room);
                                room.connect(this.buildEndpoint(room.getId(), room.getOptions()), this.httpHeaders);
                                this.connectingRooms.remove(requestId);
                                break;
                            }
                            case 11: {
                                System.out.println("Protocol: JOIN_ERROR");
                                System.err.println("colyseus.js: server error: + " + arrayValue.get(2).toString());
                                if (this.listener != null) {
                                    this.listener.onError(new Exception(arrayValue.get(2).toString()));
                                    break;
                                }
                                break block28;
                            }
                            case 20: {
                                System.out.println("Protocol: ROOM_LIST");
                                int id = arrayValue.get(1).asIntegerValue().asInt();
                                System.out.println("id: " + id);
                                ArrayValue roomsArrayValue = arrayValue.get(2).asArrayValue();
                                ArrayList<AvailableRoom> availableRooms = new ArrayList<AvailableRoom>();
                                for (int i = 0; i < roomsArrayValue.size(); ++i) {
                                    MapValue roomMapValue = roomsArrayValue.get(i).asMapValue();
                                    AvailableRoom room = new AvailableRoom();
                                    for (Map.Entry entry : roomMapValue.entrySet()) {
                                        switch (((Value)entry.getKey()).asStringValue().asString()) {
                                            case "clients": {
                                                room.clients = ((Value)entry.getValue()).asIntegerValue().asInt();
                                                break;
                                            }
                                            case "maxClients": {
                                                room.maxClients = ((Value)entry.getValue()).asIntegerValue().asInt();
                                                break;
                                            }
                                            case "roomId": {
                                                room.roomId = ((Value)entry.getValue()).asStringValue().asString();
                                                break;
                                            }
                                            case "metadata": {
                                                room.metadata = (Value)entry.getValue();
                                            }
                                        }
                                    }
                                    availableRooms.add(room);
                                }
                                if (this.roomsAvailableRequests.containsKey(id)) {
                                    this.roomsAvailableRequests.get(id).callback(availableRooms);
                                    break;
                                }
                                System.out.println("receiving ROOM_LIST after timeout:" + roomsArrayValue);
                                break;
                            }
                            default: {
                                this.dispatchOnMessage(bytes);
                            }
                        }
                        break block28;
                    }
                    this.dispatchOnMessage(bytes);
                    break block28;
                }
                this.dispatchOnMessage(bytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void dispatchOnMessage(byte[] bytes) throws IOException {
        if (this.listener != null) {
            this.listener.onMessage(this.objectMapper.readValue(bytes, (TypeReference)new TypeReference<Object>(){}));
        }
    }

    public static class AvailableRoom {
        public int clients;
        public int maxClients;
        public String roomId;
        public Value metadata;

        public String toString() {
            return "{clients:" + this.clients + ", maxClients:" + this.maxClients + ", roomId:" + this.roomId + ", metadata:" + this.metadata + ", }";
        }
    }

    public static interface AvailableRoomsRequestListener {
        public void callback(List<AvailableRoom> var1);
    }

    public static interface GetAvailableRoomsCallback {
        public void onCallback(List<AvailableRoom> var1, String var2);
    }

    public static interface Listener {
        public void onOpen();

        public void onMessage(Object var1);

        public void onClose(int var1, String var2, boolean var3);

        public void onError(Exception var1);
    }
}

