/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.loans;

import ir.boommarket.Asserts;
import ir.boommarket.BoomApi;
import ir.boommarket.Requests;
import ir.boommarket.loans.LoanDetails;
import ir.boommarket.loans.LoanDetailsRequest;
import ir.boommarket.loans.LoanOwner;
import okhttp3.Request;

public class Loans {
    public static LoanDetails getDetails(LoanDetailsRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be null");
        Asserts.notNull(boomApi, "boomApi can't be null");
        String url = boomApi.baseUrl() + "loans/" + request.loanNumber + request.toQueryParam();
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).get().build();
        return Requests.sendRequest(httpRequest, LoanDetails.class);
    }

    public static LoanOwner getLoanOwner(String loanNumber, BoomApi boomApi) {
        Asserts.notBlank(loanNumber, "loanNumber can't be blank");
        Asserts.notNull(boomApi, "boomApi can't be null");
        String url = boomApi.baseUrl() + "loans/owner?loan_number=" + loanNumber;
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).get().build();
        return Requests.sendRequest(httpRequest, LoanOwner.class);
    }
}

