/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.loans;

import ir.boommarket.Asserts;
import ir.boommarket.QueryParams;
import ir.boommarket.loans.PayStatus;

public class LoanDetailsRequest {
    final String loanNumber;
    final boolean hasDetail;
    final PayStatus payStatus;
    final Long length;
    final Long offset;

    String toQueryParam() {
        return QueryParams.newQuery().with("has_detail", this.hasDetail).with("pay_status", (Object)this.payStatus).with("length", this.length).with("offset", this.offset).toString();
    }

    private LoanDetailsRequest(String loanNumber, boolean hasDetail, PayStatus payStatus, Long length, Long offset) {
        Asserts.notBlank(loanNumber, "Loan number can't be null");
        this.validatePaginationParameters(length, offset);
        this.loanNumber = loanNumber;
        this.hasDetail = hasDetail;
        this.payStatus = payStatus;
        this.length = length;
        this.offset = offset;
    }

    public static Builder forLoanNumber(String loanNumber) {
        return new Builder().withLoanNumber(loanNumber);
    }

    private void validatePaginationParameters(Long length, Long offset) {
        if (length != null && length <= 0L) {
            throw new IllegalArgumentException("Length can't be less than or equal to zero");
        }
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("Offset can't be less than zero");
        }
    }

    public static class Builder {
        private String loanNumber;
        private boolean hasDetail = false;
        private PayStatus payStatus;
        private Long length;
        private Long offset;

        public Builder withLoanNumber(String loanNumber) {
            this.loanNumber = loanNumber;
            return this;
        }

        public Builder showDetails() {
            this.hasDetail = true;
            return this;
        }

        public Builder withPayStatus(PayStatus payStatus) {
            this.payStatus = payStatus;
            return this;
        }

        public Builder withLength(Long length) {
            this.length = length;
            return this;
        }

        public Builder withOffset(Long offset) {
            this.offset = offset;
            return this;
        }

        public LoanDetailsRequest build() {
            return new LoanDetailsRequest(this.loanNumber, this.hasDetail, this.payStatus, this.length, this.offset);
        }
    }
}

