/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.deposits;

import ir.boommarket.deposits.AutoTransferStatus;
import java.math.BigDecimal;
import java.util.Date;

public class ReportAutoTransferRequest {
    final String sourceDepositNumber;
    final String destinationDepositNumber;
    final String serial;
    final Date startDate;
    final Date endDate;
    final BigDecimal minAmount;
    final BigDecimal maxAmount;
    final Long offset;
    final Long length;
    final AutoTransferStatus autoTransferStatus;

    private ReportAutoTransferRequest(String sourceDepositNumber, String destinationDepositNumber, String serial, Date startDate, Date endDate, BigDecimal minAmount, BigDecimal maxAmount, Long offset, Long length, AutoTransferStatus autoTransferStatus) {
        this.notZeroOrNegativeAmount(minAmount);
        this.notZeroOrNegativeAmount(maxAmount);
        this.notZeroOrNegative(length);
        this.notNegative(offset);
        this.sourceDepositNumber = sourceDepositNumber;
        this.destinationDepositNumber = destinationDepositNumber;
        this.serial = serial;
        this.startDate = startDate;
        this.endDate = endDate;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.offset = offset;
        this.length = length;
        this.autoTransferStatus = autoTransferStatus;
    }

    public static ReportAutoTransferRequest withoutFilter() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void notBlankString(String depositNumber) {
        if (depositNumber != null && depositNumber.trim().isEmpty()) {
            throw new IllegalArgumentException("depositNumber can't be a blank string");
        }
    }

    private void notNegative(Long offset) {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("offset can't be a negative number");
        }
    }

    private void notZeroOrNegative(Long length) {
        if (length != null && length <= 0L) {
            throw new IllegalArgumentException("Length can't be less than or equal to zero");
        }
    }

    private void notZeroOrNegativeAmount(BigDecimal amount) {
        if (amount != null && amount.signum() <= 0) {
            throw new IllegalArgumentException("amount can't be a negative value");
        }
    }

    public static class Builder {
        private String sourceDepositNumber;
        private String destinationDepositNumber;
        private String serial;
        private Date startDate;
        private Date endDate;
        private BigDecimal minAmount;
        private BigDecimal maxAmount;
        private Long offset;
        private Long length;
        private AutoTransferStatus autoTransferStatus;

        public Builder withSourceDepositNumber(String sourceDepositNumber) {
            this.sourceDepositNumber = sourceDepositNumber;
            return this;
        }

        public Builder withDestinationDepositNumber(String destinationDepositNumber) {
            this.destinationDepositNumber = destinationDepositNumber;
            return this;
        }

        public Builder withSerial(String serial) {
            this.serial = serial;
            return this;
        }

        public Builder withStartDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder withEndDate(Date endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder withMinAmount(BigDecimal minAmount) {
            this.minAmount = minAmount;
            return this;
        }

        public Builder withMaxAmount(BigDecimal maxAmount) {
            this.maxAmount = maxAmount;
            return this;
        }

        public Builder withLength(Long length) {
            this.length = length;
            return this;
        }

        public Builder withOffset(Long offset) {
            this.offset = offset;
            return this;
        }

        public Builder withAutoTransferStatus(AutoTransferStatus autoTransferStatus) {
            this.autoTransferStatus = autoTransferStatus;
            return this;
        }

        public ReportAutoTransferRequest build() {
            return new ReportAutoTransferRequest(this.sourceDepositNumber, this.destinationDepositNumber, this.serial, this.startDate, this.endDate, this.minAmount, this.maxAmount, this.offset, this.length, this.autoTransferStatus);
        }
    }
}

