/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.deposits;

import com.fasterxml.jackson.annotation.JsonProperty;
import ir.boommarket.Asserts;
import java.math.BigDecimal;
import java.util.List;

public class BatchTransferRequest {
    final String sourceDepositNumber;
    @JsonProperty(value="destination_batch_transfer")
    final List<TransferDestination> destinationBatchTransfers;
    public String sourceDescription;
    public boolean ignoreError = false;

    public BatchTransferRequest(String sourceDepositNumber, List<TransferDestination> destinationBatchTransfers) {
        this(sourceDepositNumber, destinationBatchTransfers, null, false);
    }

    public BatchTransferRequest(String sourceDepositNumber, List<TransferDestination> destinationBatchTransfers, String sourceDescription, boolean ignoreError) {
        Asserts.notBlank(sourceDepositNumber, "The sourceDepositNumber can not be null or a blank string");
        this.destinationsNotBeNullOrEmpty(destinationBatchTransfers);
        this.sourceDepositNumber = sourceDepositNumber;
        this.sourceDescription = sourceDescription;
        this.destinationBatchTransfers = destinationBatchTransfers;
        this.ignoreError = ignoreError;
    }

    private void destinationsNotBeNullOrEmpty(List<TransferDestination> destinationBatchTransfers) {
        if (destinationBatchTransfers == null || destinationBatchTransfers.isEmpty()) {
            throw new IllegalArgumentException("List of destinationBatchTransfer can not be null or empty");
        }
    }

    public static class TransferDestination {
        final String destinationDepositNumber;
        final BigDecimal amount;
        public String description;

        public TransferDestination(String destinationDepositNumber, BigDecimal amount) {
            this(destinationDepositNumber, amount, null);
        }

        public TransferDestination(String destinationDepositNumber, BigDecimal amount, String description) {
            this.validationParameters(destinationDepositNumber, amount);
            this.destinationDepositNumber = destinationDepositNumber;
            this.amount = amount;
            this.description = description;
        }

        private void validationParameters(String destinationDepositNumber, BigDecimal amount) {
            Asserts.notBlank(destinationDepositNumber, "The destinationDepositNumber can not be null or a blank string");
            if (amount == null || amount.signum() <= 0) {
                throw new IllegalArgumentException("The amount can not be null or a negative value");
            }
        }
    }
}

