/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.deposits;

import ir.boommarket.Asserts;
import ir.boommarket.deposits.Term;
import java.math.BigDecimal;
import java.util.Date;

public class AutoTransferRequest {
    final BigDecimal amount;
    final String destinationDepositNumber;
    final String sourceDepositNumber;
    final Date startDate;
    final short termLength;
    final Term termType;
    final short transactionCount;
    final long tryCountDay;

    private AutoTransferRequest(BigDecimal amount, String destinationDepositNumber, String sourceDepositNumber, Date startDate, short termLength, Term termType, short transactionCount, long tryCountDay) {
        this.amountNotZeroOrNegative(amount);
        this.sourceDepositNotNullOrEmpty(sourceDepositNumber);
        this.destinationDepositNotNullOrEmpty(destinationDepositNumber);
        this.startDateNotNull(startDate);
        this.termLengthNotZero(termLength);
        this.termTypeNotNull(termType);
        this.transactionCountNotZero(transactionCount);
        this.amount = amount;
        this.destinationDepositNumber = destinationDepositNumber;
        this.sourceDepositNumber = sourceDepositNumber;
        this.startDate = startDate;
        this.termLength = termLength;
        this.termType = termType;
        this.transactionCount = transactionCount;
        this.tryCountDay = tryCountDay;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void amountNotZeroOrNegative(BigDecimal amount) {
        if (amount == null || amount.signum() <= 0) {
            throw new IllegalArgumentException("Amount can not be null or negative");
        }
    }

    private void destinationDepositNotNullOrEmpty(String destinationDepositNumber) {
        Asserts.notBlank(destinationDepositNumber, "DestinationDepositNumber can not be null or a blank string");
    }

    private void sourceDepositNotNullOrEmpty(String sourceDepositNumber) {
        Asserts.notBlank(sourceDepositNumber, "SourceDepositNumber can not be null or a blank string");
    }

    private void startDateNotNull(Date startDate) {
        Asserts.notNull(startDate, "StartDate can not be null");
    }

    private void transactionCountNotZero(short transactionCount) {
        if (transactionCount <= 0) {
            throw new IllegalArgumentException("transactionCount can not be zero or a negative value");
        }
    }

    private void termTypeNotNull(Term termType) {
        Asserts.notNull((Object)termType, "TermType can not be a null value");
    }

    private void termLengthNotZero(short termLength) {
        if (termLength <= 0) {
            throw new IllegalArgumentException("TermLength can not be zero or a negative value");
        }
    }

    public static class Builder {
        private BigDecimal amount;
        private String destinationDepositNumber;
        private String sourceDepositNumber;
        private Date startDate;
        private short termLength;
        private Term termType;
        private short transactionCount;
        private long tryCountDay;

        public Builder withAmount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public Builder withDestinationDepositNumber(String destinationDepositNumber) {
            this.destinationDepositNumber = destinationDepositNumber;
            return this;
        }

        public Builder withSourceDepositNumber(String sourceDepositNumber) {
            this.sourceDepositNumber = sourceDepositNumber;
            return this;
        }

        public Builder withStartDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder withTermLength(short termLength) {
            this.termLength = termLength;
            return this;
        }

        public Builder withTermType(Term termType) {
            this.termType = termType;
            return this;
        }

        public Builder withTransactionCount(short transactionCount) {
            this.transactionCount = transactionCount;
            return this;
        }

        public Builder withTryCountDay(long tryCountDay) {
            this.tryCountDay = tryCountDay;
            return this;
        }

        public AutoTransferRequest build() {
            return new AutoTransferRequest(this.amount, this.destinationDepositNumber, this.sourceDepositNumber, this.startDate, this.termLength, this.termType, this.transactionCount, this.tryCountDay);
        }
    }
}

