/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.cards;

import ir.boommarket.Asserts;
import ir.boommarket.BoomApi;
import ir.boommarket.Json;
import ir.boommarket.Requests;
import ir.boommarket.cards.CardBalance;
import ir.boommarket.cards.CardBalanceRequest;
import ir.boommarket.cards.CardHolder;
import ir.boommarket.cards.CardHolderRequest;
import ir.boommarket.cards.CardList;
import ir.boommarket.cards.CardListRequest;
import ir.boommarket.cards.CardTransactions;
import ir.boommarket.cards.CardTransfer;
import ir.boommarket.cards.CardTransferRequest;
import ir.boommarket.cards.ListTransactionsRequest;
import okhttp3.Request;

public class Cards {
    public static CardBalance getBalance(CardBalanceRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be a null value");
        Asserts.notNull(boomApi, "boomApi can't be a null value");
        String url = boomApi.baseUrl() + "cards/" + request.pan + "/balance";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, CardBalance.class);
    }

    public static CardHolder getHolder(CardHolderRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be null");
        Asserts.notNull(boomApi, "boomApi can't be null");
        String url = boomApi.baseUrl() + "cards/" + request.pan + "/holder";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, CardHolder.class);
    }

    public static CardList getCards(CardListRequest request, BoomApi boomApi) {
        Asserts.notNull(boomApi, "boomApi can't be null");
        if (request == null) {
            request = CardListRequest.withoutFilter();
        }
        String url = boomApi.baseUrl() + "cards/";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, CardList.class);
    }

    public static CardTransactions listTransactions(ListTransactionsRequest listTransactionsRequest, BoomApi boomApi) {
        Asserts.notNull(listTransactionsRequest, "listTransactionsRequest can't be a null value");
        Asserts.notNull(boomApi, "boomApi can't be null value");
        String url = String.format(boomApi.baseUrl() + "cards/%s/transactions", listTransactionsRequest.pan);
        Request request = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(listTransactionsRequest)).build();
        return Requests.sendRequest(request, CardTransactions.class);
    }

    public static CardTransfer transfer(CardTransferRequest request, BoomApi boomApi) {
        Asserts.notNull(request, "request can't be null");
        Asserts.notNull(boomApi, "boomApi can't be null");
        String url = boomApi.baseUrl() + "cards/transfer";
        Request httpRequest = Requests.withCommonHeaders(new Request.Builder(), boomApi).url(url).post(Json.of(request)).build();
        return Requests.sendRequest(httpRequest, CardTransfer.class);
    }
}

