/*
 * Decompiled with CFR 0.152.
 */
package ir.boommarket.cards;

import ir.boommarket.cards.TransferDestinationType;
import java.math.BigDecimal;

public class CardTransferRequest {
    final String pinType = "EPAY";
    final String pan;
    final String pin;
    final String cvv2;
    final String expDate;
    final String destination;
    final TransferDestinationType destinationType;
    final BigDecimal amount;

    public CardTransferRequest(String pan, String pin, String cvv2, String expDate, String destination, TransferDestinationType destinationType, BigDecimal amount) {
        this.panNotEmpty(pan);
        this.pinNotEmpty(pin);
        this.cvv2NotEmpty(cvv2);
        this.expDateNotEmpty(expDate);
        this.destinationNotEmpty(destination);
        this.transferDestinationTypeNotNull(destinationType);
        this.amountNotNegativeOrZero(amount);
        this.pan = pan;
        this.pin = pin;
        this.cvv2 = cvv2;
        this.expDate = expDate;
        this.destination = destination;
        this.destinationType = destinationType;
        this.amount = amount;
    }

    private void amountNotNegativeOrZero(BigDecimal amount) {
        if (amount == null || amount.signum() <= 0) {
            throw new IllegalArgumentException("Amount can't be null or negative");
        }
    }

    private void transferDestinationTypeNotNull(TransferDestinationType destinationType) {
        if (destinationType == null) {
            throw new IllegalArgumentException("Destination type can't be null");
        }
    }

    private void destinationNotEmpty(String destination) {
        if (destination == null || destination.trim().isEmpty()) {
            throw new IllegalArgumentException("Destination can't be a blank string");
        }
    }

    private void expDateNotEmpty(String expDate) {
        if (expDate == null || expDate.trim().isEmpty()) {
            throw new IllegalArgumentException("ExpDate can't be a blank string");
        }
    }

    private void cvv2NotEmpty(String cvv2) {
        if (cvv2 == null || cvv2.trim().isEmpty()) {
            throw new IllegalArgumentException("cvv2 can't be a blank string");
        }
    }

    private void pinNotEmpty(String pin) {
        if (pin == null || pin.trim().isEmpty()) {
            throw new IllegalArgumentException("Pin can't be a blank string");
        }
    }

    private void panNotEmpty(String pan) {
        if (pan == null || pan.trim().isEmpty()) {
            throw new IllegalArgumentException("Pan can't be a blank string");
        }
    }
}

